function lbmap = util_show_2dsegs( seglbs_per_sample,sketchimg,varargin )
pp = inputParser;
pp.addParamValue('showseglbs',false);
pp.parse(varargin{:});

lbmap = zeros(size(sketchimg));
lbmap(sketchimg) = seglbs_per_sample;

if nargout == 0
    hold on;
    imshow(label2rgb(lbmap));

    pts = util_pts_from_bwimg(sketchimg);
    if pp.Results.showseglbs
        useglbs = unique(seglbs_per_sample(:));
        for i=1:length(useglbs)
            thiseglb = useglbs(i);
            segpts = pts(:,seglbs_per_sample == thiseglb);
            meanpos = mean(segpts,2);
            distlist = pdist2(meanpos(:)',segpts');
            [~,idxmin] = min(distlist);
            pos = segpts(:,idxmin);

            str = sprintf('\\bf %s',num2str(thiseglb));
            text(pos(2),pos(1),str);
        end
    end
    lbmap = [];
end

end

