function [imgpts,mask] = util_rasterize_polyline_bresenham(pts,imgsize)
mask = false(imgsize);
if size(pts,2)==1
    imgpts = round(pts);
else
    imgptslist = cell(1,size(pts,2)-1);
    for i=1:size(pts,2)-1
        p0 = pts(:,i);
        p1 = pts(:,i+1);
        [xs,ys] = bresenham(p0(1),p0(2),p1(1),p1(2));
        imgptslist{i} = [xs(:),ys(:)]';
    end
    imgpts = cat(2,imgptslist{:});
    imgpts = round(imgpts);
    [ps,idx] = unique(imgpts','rows');
    [~,idxsort] = sort(idx);
    imgpts = ps(idxsort,:)';
end
maskuse = imgpts(1,:)>=1 & imgpts(1,:)<=imgsize(1) & imgpts(2,:)>=1 & imgpts(2,:)<=imgsize(2);
imgpts = imgpts(:,maskuse);
inds = sub2ind(imgsize,imgpts(1,:),imgpts(2,:));
mask(inds) = true;

end