function model = util_gurobi_from_mip( f,A,b,Aeq,beq,idxbin,idxint,sos )
% mixed integer programing with Ax<=b and Aeq*x=beq
% idxint = indices of variables that are integer
% idxbin = indices of variables that are binary
% other variables are continuous

if nargin<6
    idxbin = [];
end

if nargin<7
    idxint = [];
end

if nargin<8
    sos = [];
end

if isempty(f)
    f = zeros(size(A,2),1);
end

nA = size(A,1);
nAeq = size(Aeq,1);
nvar = size(A,2);

model.A = sparse(cat(1,A,Aeq));
model.rhs = full(cat(1,b(:),beq(:)));
model.obj = f(:);

vtype = char(zeros(1,nvar));
vtype(:) = 'C';
vtype(idxbin) = 'B';
vtype(idxint) = 'I';
model.vtype = vtype;

model.modelsense = 'min';

sense = zeros(1,nA+nAeq);
sense = char(sense);
sense(1:nA) = '<';
sense(nA+1:end) = '=';
model.sense = sense;

if ~isempty(sos)
    model.sos = sos;
end

end

