function [namelist,typestrlist,namelistfull,namelist_disp] = ...
    util_get_name_by_label( lbs )
% [namelist,typestrlist,namelistfull,namelist_disp] = util_get_name_by_label( lbs )
% namelist_disp = display names

if isempty(lbs)
    namelist = {};
    return;
end

objtypes = GLOBALCONST.LABEL_CATEGORIES;
lbsall = [];
namelistall = {};
namelistall_full = {};
typestrlist = {};

for i=1:length(objtypes)
    [thislbs,subnames] = util_get_label_set_by_name(objtypes{i});
    lbsall = cat(2,lbsall,thislbs(:)');
    subnames = lower(subnames);
    namelistall_full = cat(1,namelistall_full,subnames);
    
    for k=1:length(subnames)
        str = subnames{k};
        tmp = regexp(str,'_','split');
        typestrlist{end+1} = tmp{1};
        namelistall{end+1} = tmp{2};
%         str = strrep(str,objtypes{i},'');
%         str = strrep(str,'_','');
%         subnames{k} = str;
    end
%     namelistall = cat(1,namelistall,subnames);
end

[tf,loc] = ismember(lbs,lbsall);
loc(~tf)=1;
namelist = namelistall(loc);
namelist = namelist(:)';

namelistfull = namelistall_full(loc);
namelistfull = namelistfull(:)';

typestrlist = typestrlist(loc);
typestrlist = typestrlist(:)';

namelist(~tf) = {[]};
namelistfull(~tf) = {[]};
typestrlist(~tf) = {[]};

namelist_disp = namelist;
for i=1:length(namelist_disp)
    thisname = namelist_disp{i};
    thislb = lbs(i);
    switch thislb
        case GLOBALCONST.HUMAN_UPPERARM
            thisname = 'arm';
        case GLOBALCONST.HUMAN_UPPERLEG
            thisname = 'leg';
        case GLOBALCONST.CHAIR_LEGSUPPORT
            thisname = 'gas lift';
    end
    namelist_disp{i} = thisname;
end
end

