function sketchdata = srec_sequence_stroke_pts( sketchdata )
% sort out stroke points

pts_per_stroke = sketchdata.get_stroke_pts;
vecpts_per_seglbs = sketchdata.m_vecpts_per_seglb;
segcontgroup = sketchdata.segcontgroups;
vecpts_per_stroke = cell(1,length(pts_per_stroke));
for i=1:length(pts_per_stroke)
    seglbs = segcontgroup{i};
    vecpts = cat(2,vecpts_per_seglbs{seglbs});
    vecpts_per_stroke{i} = vecpts;
end

% make a sequence map for each stroke
nstroke = length(pts_per_stroke);
imgsize = size(sketchdata.m_sketchimg);
seqmap_per_stroke = cell(1,nstroke);
seqmap_master = sketchdata.m_seqmap;
for i=1:nstroke
    pts = pts_per_stroke{i};
    if isempty(pts)
        continue;
    end
    hitmask = false(imgsize);
    inds = sub2ind(imgsize,pts(1,:),pts(2,:));
    hitmask(inds) = true;
    pts = util_pts_from_bwimg(hitmask);
    s = seqmap_master(inds);
    [~,idx] = sort(s);
    pts = pts(:,idx);
    pts_per_stroke{i} = pts;
    
    inds = sub2ind(imgsize,pts(1,:),pts(2,:));
    seqmap = zeros(imgsize);
    seqmap(inds) = 1:length(inds);
    seqmap_per_stroke{i} = seqmap;
end
sketchdata.m_imgpts_per_stroke = pts_per_stroke;

% find out sequenced segpts
seglbs_per_stroke = sketchdata.segcontgroups;
maxseglbs = max(sketchdata.m_seglbs_per_sketchpts);
imgpts_per_seglbs = cell(1,maxseglbs);
indsall = find(sketchdata.m_sketchimg);
ptsketch = sketchdata.ptsketch;
for i=1:nstroke
    seglbs = seglbs_per_stroke{i};
    seqmap = seqmap_per_stroke{i};
    for k=1:length(seglbs)
        thiseglb = seglbs(k);
        
        % points of this seglb
        idx = find(sketchdata.m_seglbs_per_sketchpts == thiseglb);
        segpts = ptsketch(:,idx);
        
        % sequence of points for this seglb
        inds = indsall(idx);
        seq = seqmap(inds);
        [~,idxsort] = sort(seq);
        imgpts_per_seglbs{thiseglb} = segpts(:,idxsort);
    end
end
sketchdata.m_imgpts_per_seglb = imgpts_per_seglbs;

% find out sequenced line points
nline = length(sketchdata.m_imgpts_per_line);
imgpts_per_line = sketchdata.m_imgpts_per_line;
linemap = sketchdata.get_lbmap_from_segroup(sketchdata.seglinegroups);
for i=1:nline
    % points of this line
    imgpts_original = imgpts_per_line{i};
    if isempty(imgpts_original)
        continue;
    end
    hitmask = linemap == i;
    imgpts = util_pts_from_bwimg(hitmask);
    inds = sub2ind(size(hitmask),imgpts(1,:),imgpts(2,:));
    s = seqmap_master(inds);
    [~,idx] = sort(s);
    imgpts_per_line{i} = imgpts(:,idx);
end
sketchdata.m_imgpts_per_line = imgpts_per_line;

end

function sketchdata = srec_sequence_stroke_pts_old( sketchdata )
% sort out stroke points

pts_per_stroke = sketchdata.get_stroke_pts;
% pts_per_stroke = sketchdata.m_imgpts_per_stroke;
vecpts_per_seglbs = sketchdata.m_vecpts_per_seglb;
segcontgroup = sketchdata.segcontgroups;
vecpts_per_stroke = cell(1,length(pts_per_stroke));
for i=1:length(pts_per_stroke)
    seglbs = segcontgroup{i};
    vecpts = cat(2,vecpts_per_seglbs{seglbs});
    vecpts_per_stroke{i} = vecpts;
end

% make a sequence map for each stroke
nstroke = length(pts_per_stroke);
imgsize = size(sketchdata.m_sketchimg);
seqmap_per_stroke = cell(1,nstroke);
for i=1:nstroke
    pts = pts_per_stroke{i};
    if isempty(pts)
        continue;
    end
    hitmask = false(imgsize);
    inds = sub2ind(imgsize,pts(1,:),pts(2,:));
    hitmask(inds) = true;
    
    startnear = pts(:,1);
    pts = util_pts_from_bwimg(hitmask);
    
    % get a preorder
    vecpts = vecpts_per_stroke{i};
    idx = knnsearch(vecpts',pts');
    [~,preseq] = sort(idx);
    
    idx = srec_sequence_pts(pts,'startnear',startnear,'preseq',preseq);
    pts = pts(:,idx);
    pts_per_stroke{i} = pts;
    
    inds = sub2ind(imgsize,pts(1,:),pts(2,:));
    seqmap = zeros(imgsize);
    seqmap(inds) = 1:length(inds);
    seqmap_per_stroke{i} = seqmap;
end
sketchdata.m_imgpts_per_stroke = pts_per_stroke;

% find out sequenced segpts
seglbs_per_stroke = sketchdata.segcontgroups;
maxseglbs = max(sketchdata.m_seglbs_per_sketchpts);
imgpts_per_seglbs = cell(1,maxseglbs);
indsall = find(sketchdata.m_sketchimg);
ptsketch = sketchdata.ptsketch;
for i=1:nstroke
    seglbs = seglbs_per_stroke{i};
    seqmap = seqmap_per_stroke{i};
    for k=1:length(seglbs)
        thiseglb = seglbs(k);
        
        % points of this seglb
        idx = find(sketchdata.m_seglbs_per_sketchpts == thiseglb);
        segpts = ptsketch(:,idx);
        
        % sequence of points for this seglb
        inds = indsall(idx);
        seq = seqmap(inds);
        [~,idxsort] = sort(seq);
        imgpts_per_seglbs{thiseglb} = segpts(:,idxsort);
    end
end
sketchdata.m_imgpts_per_seglb = imgpts_per_seglbs;

% find out sequenced line points
nline = length(sketchdata.m_imgpts_per_line);
imgpts_per_line = sketchdata.m_imgpts_per_line;
linemap = sketchdata.get_lbmap_from_segroup(sketchdata.seglinegroups);
for i=1:nline
    % points of this line
    imgpts_original = imgpts_per_line{i};
    if isempty(imgpts_original)
        continue;
    end
    hitmask = linemap == i;
    imgpts = util_pts_from_bwimg(hitmask);
    startnear = imgpts_per_line{i}(:,1);
    seq = srec_sequence_pts(imgpts,'startnear',startnear);
    imgpts_per_line{i} = imgpts(:,seq);
end
sketchdata.m_imgpts_per_line = imgpts_per_line;

end