function gmodel = srec_addcons_wing2body( gmodel,linmodel,samplegraph )
% for airplane, wing must connect to body if it's selected

if ~strcmpi(samplegraph.objtypestr,'airplane')
    % this constraint is only applicable to airplane
    return;
end

x2varidx = 1:linmodel.nx;
y2varidx = linmodel.y2varidx;
edgeidxmap = linmodel.edgeidxmap;
edgeidxmap = tril(edgeidxmap,-1) + triu(edgeidxmap,1);
nvar = size(gmodel.A,2);

xs_wing = find(samplegraph.m_complabels == GLOBALCONST.AIRPLANE_WING);
xs_body = find(samplegraph.m_complabels == GLOBALCONST.AIRPLANE_BODY);
ijks = zeros(3,0);
ijks_eq = zeros(3,0);
idxlastrow  = 0;
idxlastrow_eq = 0;
for i=1:length(xs_wing)
    x = xs_wing(i);
    xx = x2varidx(x);
    
    % which edge links this wing to body?
    ys = edgeidxmap(x,xs_body);
    ys = ys(ys>0);
    ys = ys(:)';
    if isempty(ys)
        % not connected to body? this wing is not selectable
        % x=0
        ents = [idxlastrow_eq+1,xx,1]';
        ijks_eq = cat(2,ijks_eq,ents);
        idxlastrow_eq = idxlastrow_eq+1; 
    else
        % one of these edges must be selected
        % sum(yi)>=x --> x-sum(yi)<=0
        yy = y2varidx(ys);
        ents = zeros(3,length(ys)+1);
        ents(1,:) = idxlastrow +1;
        ents(2,:) = [xx,yy];
        ents(3,:) = [1,-ones(1,length(ys))];
        ijks = cat(2,ijks,ents);
        idxlastrow = idxlastrow + 1;
    end
end
if ~isempty(ijks)
    coefA_wing2body = sparse(ijks(1,:),ijks(2,:),ijks(3,:),max(ijks(1,:)),nvar);
else
    coefA_wing2body = sparse(0,nvar);
end
b_wing2body = zeros(size(coefA_wing2body,1),1);

if ~isempty(ijks_eq)
    coefAeq_wing2body = sparse(ijks_eq(1,:),ijks_eq(2,:),ijks_eq(3,:),max(ijks_eq(1,:)),nvar);
else
    coefAeq_wing2body = sparse(0,nvar);
end
beq_wing2body = zeros(size(coefAeq_wing2body,1),1);

%% add to gmodel
coefA_new = cat(1,coefA_wing2body,coefAeq_wing2body);
b_new = cat(1,b_wing2body,beq_wing2body);
sense = zeros(1,size(coefA_new,1));
sense(1:size(coefA_wing2body,1)) = '<';
sense(end-size(coefAeq_wing2body,1)+1:end) = '=';
ncons_new = size(coefA_new,1);

gmodel.A = cat(1,gmodel.A,coefA_new);
gmodel.sense(end+1:end+ncons_new) = sense;
gmodel.rhs = cat(1,gmodel.rhs,b_new);

end

