function gmodel = srec_addcons_table_midsupport_have_top( gmodel,linmodel,samplegraph )
% for a table, midsupport can only be selected if a table top is selected

if ~strcmpi(samplegraph.objtypestr,'table')
    return;
end

x2varidx = 1:linmodel.nx;
xs_midsupport = find(samplegraph.m_complabels == GLOBALCONST.TABLE_MIDSUPPORT);
xs_top = find(samplegraph.m_complabels == GLOBALCONST.TABLE_TOP);
if isempty(xs_top)
    %no table top? 
    return;
end
nvar_previous = size(gmodel.A,2);
nvar = nvar_previous+1;

% u==1 iff one table top is selected
u2varidx = nvar_previous+1;

%% define table top selection indicator
% u>=xk --> xk-u<=0, u<=sum(xk) --> u-sum(xk)<=0

% u>=xk
ents = zeros(6,length(xs_top));
xx = x2varidx(xs_top);
uu = u2varidx(1);
ents(1,:) = 1:length(xs_top);
ents(2,:) = xx;
ents(3,:) = 1;
ents(4,:) = ents(1,:);
ents(5,:) = uu;
ents(6,:) = -1;
ijks = cat(2,ents(1:3,:),ents(4:6,:));

% u<=sum(xk)
ents = zeros(3,length(xs_top)+1);
ents(1,:) = max(ijks(1,:))+1;
ents(2,:) = [uu,xx];
ents(3,:) = [1,-ones(1,length(xx))];
ijks = cat(2,ijks,ents);

if ~isempty(ijks)
    coefA_topsel = sparse(ijks(1,:),ijks(2,:),ijks(3,:),max(ijks(1,:)),nvar);
else
    coefA_topsel = sparse(0,nvar);
end
b_topsel = zeros(size(coefA_topsel,1),1);

%% midsupport is only selectable if a top is selected
% xk<=u --> xk-u<=0
xx = x2varidx(xs_midsupport);
uu = u2varidx(1);
ents = zeros(6,length(xs_midsupport));
ents(1,:) = 1:length(xs_midsupport);
ents(2,:) = xx;
ents(3,:) = 1;
ents(4,:) = ents(1,:);
ents(5,:) = uu;
ents(6,:) = -1;
ijks = cat(2,ents(1:3,:),ents(4:6,:));

if ~isempty(ijks)
    coefA_midsel = sparse(ijks(1,:),ijks(2,:),ijks(3,:),max(ijks(1,:)),nvar);
else
    coefA_midsel = sparse(0,nvar);
end
b_midsel = zeros(size(coefA_midsel,1),1);

%% append to gmodel
coefA_new = cat(1,coefA_topsel,coefA_midsel);
b_new = cat(1,b_topsel,b_midsel);
sense = zeros(1,size(coefA_new,1));
sense(:) = '<';
sense = char(sense);
ncons_new = length(b_new);
nvar_new = nvar - nvar_previous;

gmodel.A(1,nvar) = 0;
gmodel.A = cat(1,gmodel.A,coefA_new);
gmodel.sense(end+1:end+ncons_new) = sense;
gmodel.rhs = cat(1,gmodel.rhs,b_new);
gmodel.obj(end+1:end+nvar_new) = 0;
gmodel.vtype(end+1:end+nvar_new) = 'B';

end





