classdef SBSRSKETCHOPT
    % various processing options
    
    properties
        % the id of the user input file
        m_sketch_filename
        
        % does this data originate from vector image?
        m_is_vector_image
        
        % treat vector image as raster image, only applicable when the file
        % is svg
        m_force_raster
        
        % how to segment the input sketch
        m_breakseg_by_intersection
        m_breakseg_by_arclength
        m_breakseg_by_corner
        
        % use parallel grouping?
        m_use_parallel_group
    end
    
    methods
        function filename = to_filename(obj)
            makename = @(name,flag)SBSRSKETCHOPT.make_name_component(name,flag);
            
            str_brkarc = makename(SBSRSKETCHOPT.KW_BREAK_BY_ARCLENGTH,obj.m_breakseg_by_arclength);
            str_brkcorner = makename(SBSRSKETCHOPT.KW_BREAK_BY_CORNER,obj.m_breakseg_by_corner);
            str_brkins = makename(SBSRSKETCHOPT.KW_BREAK_BY_INTERSECT,obj.m_breakseg_by_intersection);
            str_force_raster = makename(SBSRSKETCHOPT.KW_FORCE_RASTER,obj.m_force_raster);
            str_is_vector = makename(SBSRSKETCHOPT.KW_VECTOR_IMAGE,obj.m_is_vector_image);
            str_use_parallel_group = makename(SBSRSKETCHOPT.KW_PARALLEL_GROUP,obj.m_use_parallel_group);
            
            [~,fn,ext] = fileparts(obj.m_sketch_filename);
            skfilename = [fn,ext];
            filename = sprintf('[%s][%s_%s_%s_%s_%s_%s]',...
                skfilename,str_is_vector,str_force_raster,...
                str_brkins,str_brkarc,str_brkcorner,str_use_parallel_group);
        end
    end
    
    methods(Static=true)
        function obj = default_for_raster
            obj = SBSRSKETCHOPT;
            obj.m_breakseg_by_arclength = false;
            obj.m_breakseg_by_corner = true;
            obj.m_breakseg_by_intersection = true;
            obj.m_is_vector_image = false;
            obj.m_force_raster = true;
            obj.m_use_parallel_group = true;
        end
        
        function obj = default_for_vector
            obj = SBSRSKETCHOPT;
            obj.m_breakseg_by_arclength = false;
            obj.m_breakseg_by_corner = true;
            obj.m_breakseg_by_intersection = true;
            obj.m_is_vector_image = true;
            obj.m_force_raster = false;
            obj.m_use_parallel_group = true;
        end
        
        function obj = init_with_filename(filename)
            % parse filename
            obj = SBSRSKETCHOPT;
            obj.m_sketch_filename = filename;
            [~,filename] = fileparts(filename);
            
            tks = regexp(filename,'\[([^\[\]]+)\]','tokens');
            sketch_filename = tks{1}{1};
            params_string = tks{2}{1};
            obj.m_sketch_filename = sketch_filename;
            
            tokens = regexp(params_string,'_','split');
            for i=1:length(tokens)
                str = tokens{i};
                subtokens = regexp(str,'=','split');
                propname = subtokens{1};
                value = str2double(subtokens{2});
                
                switch propname
                    case SBSRSKETCHOPT.KW_BREAK_BY_ARCLENGTH
                        obj.m_breakseg_by_arclength = value>0;
                    case SBSRSKETCHOPT.KW_BREAK_BY_CORNER
                        obj.m_breakseg_by_corner = value>0;
                    case SBSRSKETCHOPT.KW_BREAK_BY_INTERSECT
                        obj.m_breakseg_by_intersection = value>0;
                    case SBSRSKETCHOPT.KW_VECTOR_IMAGE
                        obj.m_is_vector_image = value>0;
                    case SBSRSKETCHOPT.KW_FORCE_RASTER
                        obj.m_force_raster = value>0;
                    case SBSRSKETCHOPT.KW_PARALLEL_GROUP
                        obj.m_use_parallel_group = value>0;
                end
            end
        end
        
        function val = make_name_component(name,flag)
            val = sprintf('%s=%d',name,flag);
        end
        
        function val = KW_BREAK_BY_INTERSECT
            val = 'brkins';
        end
        
        function val = KW_BREAK_BY_ARCLENGTH
            val = 'brkarclen';
        end
        
        function val = KW_BREAK_BY_CORNER
            val = 'brkcorner';
        end
        
        function val = KW_VECTOR_IMAGE
            val = 'vec';
        end
        
        function val = KW_FORCE_RASTER
            val = 'rst';
        end
        
        function val = KW_PARALLEL_GROUP
            val = 'pargroup';
        end
    end
    
end

