classdef SBSRMIPOPT
    %options for running mip
    %"component" = local interpretation
    
    properties
        %% params for formulating the model
        m_mincover = 0.9; %output should cover this much of the input sketch, e.g., 0.9 means 90% of the sketch
        m_idxcompts_ignore %these local interpretations will not be selected
        m_idxcompts_fix %these local interpretations must be selected
        m_labelcount %lbcount(:,i) = [label,min,max]', how many components of a particular label can be selected
        m_mincomp = 0; %minimum number of components in final output
        m_maxcomp = inf; %maximum number of components in final output
		
		%% COST QUANTIZATION
		% quantize unary (fitness) and pairwise (connection) cost?
		% quantization will eliminate small difference in cost, sometimes
		% leads to more robust result. Note that if quantization is turned
		% on, the respective cost will be normalized to 0~1
		m_nbin_unary = 5; % quantize fitness into this many levels, 0 means disable quantization
		m_nbin_pairwise = 5; % quantize connection scores into this many levels, 0 means disable quantization
		%%
        % a name used to identify the experiment run using this mipopt
        m_name_sig = 'no name'
        
        % optimization per term control
        m_useoverlap = true; %use overlap hard constraint?
        m_usesym = false;    %use symmetric constraint? only makes a difference if the sketch has symmetry plane specified
        m_usesegassign = true; %use segment assignment?
        m_weight_cover = 100;    %benefit of covering a segment
        m_weight_mustcover = 100;   %benefit of covering a long segment
        m_weight_match = 10;   %cost of using a bad match
        m_weight_overlap = 15; %cost of selecting overlapping element
        m_weight_struct = 20;  %cost of using poor connection
        m_weight_segroup = 5;  %cost of assigning inconsistent labels to a group of segments
        m_weight_hardassign = 1;   %cost of not assigning all the segments belonging to a component
				
		% specifying only a subset of local interpretations to be used in
		% the mip model. e.g., m_subgraph_idxcompts = [1 2 3] then only the
		% first 3 local interpretations are usable
        m_subgraph_idxcompts
        
        %% internal params, do not change these if you don't know what you are doing
        m_covermode = 'normal'; %use what kind of coverage
        m_idxcompts_per_cluster %cluster idxcompts such that within a cluster, only one component can be selected
        m_seglbsgroup = {}; %group{i} = ith group of seglbs
        m_segcontgroup = {}; %group{i} = ith continuity group of seglbs
        
        % val{i}={idx1,idx2,..idxk}, such that a combination of idx1..idxk
        % will be forbiden
        m_idxcomptslist_per_combination_forbid
        
        %when set, only consider components that cover these seglbs, 
        %and other seglbs are assumed covered by a ghost element
        m_seglbs_use; 
        m_mincover_in_seglbsuse; %how much of the seglbs_use must be covered?
        
        %seglbs1 = pair{1,i}, seglbs2 = pair{2,i}, if x1 covers any of
        %seglbs1, x2 covers any of seglbs2, then x1 and x2 must connect
        m_seglbspair_connect_if_cover;  
        
        %% these are the outputs of MIP
        m_cost_cover
        m_cost_mustcover
        m_cost_match
        m_cost_overlap
        m_cost_struct
        m_cost_segroup
        m_cost_hardassign
        m_cost_total
    end
    
    methods(Static=true)
        function obj = init_with_nan
            obj = SBSRMIPOPT;
            obj = util_make_nan_object(obj);
        end
    end
end
