function obj = set_transmat_by_imgc( obj,imgsize,npixlong,varargin )
% transform the vector image to image coordinate
% imgsize = the size of image
% npixlong = the pixel count of the longest edge of bounding box

pp = inputParser;

%upper-left corner position of the transformed vector image
pp.addParamValue('cornerpos',[]); 
pp.parse(varargin{:});

% the vecimage is centered at the image frame
pts = obj.m_pts;
[boxlens,mincorner] = util_make_aabb_from_pts(pts);

% scaling
scalef = npixlong / max(boxlens);

% translation
center_before = mincorner(:) + boxlens(:)/2;
if isempty(pp.Results.cornerpos)
    center_after = floor((imgsize+1)/2);
else
    center_after = pp.Results.cornerpos(:) + boxlens(:)*scalef/2;
end

% make transformation matrix
tmat_move2origin = eye(3);
tmat_move2origin(1:2,end) = -center_before;

tmat_scale = eye(3);
tmat_scale(1:2,1:2) = eye(2) * scalef;

tmat_move2center = eye(3);
tmat_move2center(1:2,end) = center_after;

transmat =tmat_move2center * tmat_scale * tmat_move2origin;

% done
obj.m_transmat_to_imgc = transmat;
obj.m_imgsize = imgsize;


end

