function [ptslist,dirlist,idxlist] = pts_by_type(obj,typevec,varargin)
% group the points based on a type vector, where typevec(i) is the type for
% ith pts
pp = inputParser;
pp.addParamValue('ignorezero',false); %0 in typevec is a valid type?
pp.addParamValue('include_endpts',false); %the segment will include end point?
pp.parse(varargin{:});

pts = obj.pts;
dirs = obj.dirs;
utype = unique(typevec);
if pp.Results.ignorezero
    utype = utype(utype~=0);
end

ptslist = cell(1,length(utype));
dirlist = cell(1,length(utype));
idxlist = cell(1,length(utype));
strokeidx = obj.m_segby_stroke;
for i=1:length(utype)
    mask = typevec == utype(i);
    idx = find(mask);
    
    idxbegin = idx(1);
    if pp.Results.include_endpts && idxbegin>1 && strokeidx(idxbegin) == strokeidx(idxbegin-1)
        idxbegin = idxbegin-1;
    end
    
    idxend = idx(end);
    if pp.Results.include_endpts && idxend<length(typevec) && strokeidx(idxend) == strokeidx(idxend+1)
        idxend = idxend+1;
    end
    
    ptslist{i} = pts(:,idxbegin:idxend);
    dirlist{i} = dirs(:,idxbegin:idxend);
    idxlist{i} = idxbegin:idxend;
end

end

