function obj = init_with_dataset(skdata,varargin)
% create vecimage from raw data of sketch, made by
% util_dataset_from_sketchdata

% make curves from pts
ptslist = cellfun(@(x)skdata.pts(:,x.idxpts),skdata.strokes.onestroke,'uniformoutput',false);
curvelist = cellfun(@(x)util_curve_from_pts(x,'usesmooth',true),ptslist,'uniformoutput',false);
obj = SBSRVECIMAGE.init_with_curvelist(curvelist,varargin{:},'flipxy',false);
% obj = SBSRVECIMAGE.init_with_ptslist(ptslist,'flipxy',false);

% copy groundtruth
pts_old = skdata.pts;
pts_new = obj.pts;
[~,~,idxptsnew_per_stroke] = obj.pts_by_stroke;
obj.m_idxpts_per_obj = {};
obj.m_label_per_obj = [];

for i=1:length(skdata.components.onecomp)
    comp = skdata.components.onecomp{i};
    thisidx_old = comp.idxpts;
    
    idxptsnew_this_comp = [];
    % separate idx into segments in different strokes
    % and then further segment it into contigous curve segments, and map
    % the end points to the new curves
    for j=1:length(skdata.strokes.onestroke)
        idxstkpts_old = skdata.strokes.onestroke{j}.idxpts;
        idxonstk_old = intersect(thisidx_old,idxstkpts_old);
        if isempty(idxonstk_old)
            continue;
        end
        
        if length(idxonstk_old)==1
            idxonstk_old = [idxonstk_old,idxonstk_old];
        end
        
        idxonstk_old = sort(idxonstk_old(:)');
        
        % break into contiguous sequence
        dd = diff(idxonstk_old);
        mask = dd==1 | dd==0;
        cc = bwconncomp(mask);
        idxonstk_old_perseg = cellfun(@(x)[idxonstk_old(x),idxonstk_old(x(end)+1)],...
            cc.PixelIdxList,'uniformoutput',false);
        
        % points of each contigous segment
        ptsonstk_old_perseg = cellfun(@(x)pts_old(:,x),idxonstk_old_perseg,'uniformoutput',false);
        
        % map each contigous segment to new curves
        idxstkpts_new = idxptsnew_per_stroke{j};
        stkpts_new = pts_new(:,idxstkpts_new);
        for k=1:length(ptsonstk_old_perseg)
            ptsonstk_old_thiseg = ptsonstk_old_perseg{k};
            bgpt_old = ptsonstk_old_thiseg(:,1);
            endpt_old = ptsonstk_old_thiseg(:,end);
            
            [~,idxmin] = min(pdist2(bgpt_old',stkpts_new'));
            idxbgpt_new = idxstkpts_new(idxmin);
            
            [~,idxmin] = min(pdist2(endpt_old',stkpts_new'));
            idxendpt_new = idxstkpts_new(idxmin);
            
            idxptnew_add = min(idxbgpt_new,idxendpt_new):max(idxbgpt_new,idxendpt_new);
            
            ratio_old = size(ptsonstk_old_thiseg,2)/length(idxstkpts_old);
            ratio_new = length(idxptnew_add)/length(idxstkpts_new);
            
            % work around special issue, that is, a segment covers
            % i[n-1],i[n],i[1],i[2]...
            if abs(ratio_old/ratio_new-1)<0.1
                idxptsnew_this_comp = ...
                    cat(2,idxptsnew_this_comp,...
                        min(idxbgpt_new,idxendpt_new):max(idxbgpt_new,idxendpt_new));
            end
        end
    end
    
    obj.m_idxpts_per_obj{i}=idxptsnew_this_comp;
    obj.m_label_per_obj(i) = comp.label;
end
obj.m_imgsize = GLOBALCONST.DEFAULT_SKETCH_SIZE;
lbsall = cellfun(@(x)x.label,skdata.components.onecomp);
obj.m_dblbs = unique(lbsall);

if isfield(skdata,'symplane')
    obj.m_symplane_normal = skdata.symplane.normal;
    obj.m_symplane_p0 = skdata.symplane.p0;
end

if isfield(skdata,'view')
    obj.m_view = skdata.view;
end
% obj.m_dblbs = skdata.all_possible_labels;
% obj.m_imgsize = skdata.imagesize;

end

