function seglbs = cleanup_short_seglbs(seglbs,strokeidx)
% clean up short segments
% seglbs(i) = segment label for ith point

if nargin >= 2
    ustkid = unique(strokeidx);
    for i=1:length(ustkid)
        mask = strokeidx == ustkid(i);
        subseglbs = seglbs(mask);
        subseglbs = SBSRVECIMAGE.cleanup_short_seglbs(subseglbs);
        seglbs(mask) = subseglbs;
    end
    return;
end

useglbs = unique(seglbs);
useglbs = useglbs(useglbs>0);

seglens_per_seglb = zeros(1,length(useglbs));
for i=1:length(useglbs)
    seglens_per_seglb(i) = sum(seglbs == useglbs(i));
end

v = std(seglens_per_seglb);
m = mean(seglens_per_seglb);
% maskshort = (seglens_per_seglb - m)/v <= -1;
maskshort = seglens_per_seglb/v <= 0.3;
seglbs_short = useglbs(maskshort);

% for each short segment, merge to the nearest long segment
for i=1:length(seglbs_short)
    thiseglb = seglbs_short(i);
    idxpts = find(seglbs == thiseglb);
    idxbefore = idxpts(1) - 1;
    idxafter = idxpts(end)+1;
    if idxbefore>0
        newseglb = seglbs(idxbefore); %if possible, merge to before
    elseif idxafter <= length(seglbs)
        newseglb = seglbs(idxafter); %if possible, merge to after
    else
        newseglb = thiseglb; %cannot change
    end
    seglbs(idxpts) = newseglb;
end

end






