function obj = update_fullcover( obj,database )
% force each candidate component to be fully covered and record the
% coverage data

ptsketch = obj.m_cxpts;
idx = sub2ind(size(obj.m_sketchimg),ptsketch(1,:),ptsketch(2,:));
gdxsketch = obj.m_gdx(idx);
gdysketch = obj.m_gdy(idx);
dirsketch = cat(2,gdxsketch(:),gdysketch(:))';
segids = obj.m_segid_per_candpivot;
seglist = util_get_segment_by_segids(segids,database);
candpivot2sketchpts = obj.m_candpivot2cxpts;
candpivot2sketchpts(:) = 0;
candpivot2sketchpts_justenough = obj.m_candpivot2cxpts;
candpivot2sketchpts_justenough(:) = 0;

% use component to cover sketch, enforce full coverage
kdsketch = KDTreeSearcher(ptsketch');
topn = 3;

for i=1:length(seglist)
    sg = seglist{i};
    dftransmat = obj.m_dftransmat_per_candpivot{i};
    sg = sg.set_deform_transmat(dftransmat);
    ptseg = sg.ptsketch;
    dirseg = sg.gdxy;
    
    mask_covered_sketchpts_comp2sketch = false(1,size(ptsketch,2));
    mask_covered_sketchpts_sketch2comp = false(1,size(ptsketch,2));
    
    % cover from sketch to segment, ensure that each covered sketch points
    % are recorded
    covermat_sketch2seg = ...
        srec_cover_pts2pts(ptsketch,dirsketch,ptseg,dirseg);
    mask_covered_sketchpts_sketch2comp(:) = full(any(covermat_sketch2seg,2));

    % cover from segment to sketch, each point in segment must cover
    % some part in sketch
    [~,scoremat_seg2sketch,distmat_seg2sketch] = srec_cover_pts2pts(ptseg,dirseg,ptsketch,dirsketch,...
        'kdto',kdsketch,'allcover',true,'kpts',30);
    [distmat_sort,idxsort] = sort(distmat_seg2sketch,2);
    ntake = min(size(distmat_sort,2),topn);
    distblock = distmat_sort(:,1:ntake);
    idxtake = idxsort(:,1:ntake);
    idxtake = idxtake(~isnan(distblock));
    idxuse = idxtake;
    
%     [~,idxuse] = min(distmat_seg2sketch,[],2);
%     [scores,idxuse] = max(scoremat_seg2sketch,[],2);
    mask_covered_sketchpts_comp2sketch(idxuse) = true;
    
    % extend point coverage to 2d segment coverage
    mask_covered_sketchpts = mask_covered_sketchpts_comp2sketch | mask_covered_sketchpts_sketch2comp;
    lbscover = srec_cover_refine_by_segment(obj.m_seglbs_per_sketchpts,mask_covered_sketchpts);
    mask_covered_sketchpts = ismember(obj.m_seglbs_per_sketchpts,lbscover);
    
    candpivot2sketchpts(i,:) = mask_covered_sketchpts;
    
    % just enough coverage
    lbscover = srec_cover_refine_by_segment(obj.m_seglbs_per_sketchpts,mask_covered_sketchpts_comp2sketch);
    mask_covered_justenough = ismember(obj.m_seglbs_per_sketchpts,lbscover);
    candpivot2sketchpts_justenough(i,:) = mask_covered_justenough;
end

% quick fix for empty coverage in justenough cover
mask_no_cover = any(candpivot2sketchpts_justenough,2)==0;
candpivot2sketchpts_justenough(mask_no_cover,:) = obj.m_candpivot2cxpts(mask_no_cover,:);

obj.m_candpivot2cxpts_fullcover = candpivot2sketchpts;
obj.m_candpivot2cxpts_justenough = candpivot2sketchpts_justenough;

end

