function obj = update_feature_with_candpivot(obj,database,varargin)

sketchimg = obj.m_sketchimg;
candpivots = obj.m_candpivots;
matchscores = obj.m_matchscore_per_candpivot;
dblbs = database.m_labels;
lbs_per_candpivot = obj.m_lbs_per_candpivot;

% calculate context feature for each candpivot
% line direction
fprintf(1,'SKETCH:calculating line direction context\n');
cxcubes_ldir = ...
    srec_context_line_direction(sketchimg,candpivots);

% label context
scx_ndist = GLOBALCONST.SCX_NDIST;
scx_ndir = GLOBALCONST.SCX_NDIR;
maxdist = norm(GLOBALCONST.DEFAULT_SKETCH_SIZE) * GLOBALCONST.SCX_MAXDIST_TO_DIAG;

% extract label context
% normalize score for each label
fprintf(1,'SKETCH:calculating label context\n');
ws = zeros(size(matchscores));
for i=1:length(dblbs)
    mask = lbs_per_candpivot == dblbs(i);
    scores = matchscores(mask);
    totalscore = sum(scores);
    if totalscore == 0
        scores(:) = 1;
    else
        scores = scores/totalscore;
    end
    ws(mask) = scores;
end
cxcubes_label = srec_context_label_from_pts(candpivots,lbs_per_candpivot,...
    dblbs,maxdist,'weight',ws);

obj.m_cxcubes_per_candpivot_ldir = cxcubes_ldir;
obj.m_cxcubes_per_candpivot_label = cxcubes_label;
obj = obj.update_fullcover(database);

end

