function obj = subsketch_by_seglbs( obj,seglbs, varargin )

% pp = inputParser;
% pp.addParamValue('updatefeature',true);
% pp.parse(varargin{:});

newobj = obj;

maskusepts = ismember(obj.m_seglbs_per_sketchpts,seglbs);
candpivot2cxpts = obj.m_candpivot2cxpts(:,maskusepts);
maskusecandpivots = any(candpivot2cxpts,2);

newobj.m_candpivot2cxpts = obj.m_candpivot2cxpts(maskusecandpivots,maskusepts);

if ~isempty(obj.m_candpivot2cxpts_fullcover)
    newobj.m_candpivot2cxpts_fullcover = obj.m_candpivot2cxpts(maskusecandpivots,maskusepts);
end

if ~isempty(obj.m_candpivot2cxpts_justenough)
    newobj.m_candpivot2cxpts_justenough = obj.m_candpivot2cxpts_justenough(maskusecandpivots,maskusepts);
end

newobj.m_candpivots = obj.m_candpivots(:,maskusecandpivots);
newobj.m_cxpts = obj.m_cxpts(:,maskusepts);
newobj.m_cxcubes_per_candpivot_label = obj.m_cxcubes_per_candpivot_label(maskusecandpivots);
newobj.m_cxcubes_per_candpivot_ldir = obj.m_cxcubes_per_candpivot_ldir(maskusecandpivots);
newobj.m_cxscore_per_candpivot_label = obj.m_cxscore_per_candpivot_label(maskusecandpivots);
newobj.m_cxscore_per_candpivot_ldir = obj.m_cxscore_per_candpivot_ldir(maskusecandpivots);

if ~isempty(obj.m_dftransmat_per_candpivot)
    newobj.m_dftransmat_per_candpivot = obj.m_dftransmat_per_candpivot(maskusecandpivots);
end

indsimage = find(obj.m_sketchimg);
indsuse = indsimage(maskusepts);
inds_per_component = obj.m_inds_per_component;
if ~isempty(inds_per_component)
    for i=1:length(inds_per_component)
        thisinds = inds_per_component{i};
        thisinds = intersect(thisinds(:),indsuse(:));
        inds_per_component{i} = thisinds(:)';
    end
    newobj.m_inds_per_component = inds_per_component;

end
newobj.m_label_per_component = obj.m_label_per_component;

% delete empty component
mask = cellfun(@(x)~isempty(x),newobj.m_inds_per_component);
newobj.m_inds_per_component = newobj.m_inds_per_component(mask);
newobj.m_label_per_component = newobj.m_label_per_component(mask);

newobj.m_lbs_per_candpivot = obj.m_lbs_per_candpivot(maskusecandpivots);
newobj.m_matchscore_per_candpivot = obj.m_matchscore_per_candpivot(maskusecandpivots);

if ~isempty(obj.m_parallelgroup_sketchpts2sketchpts)
    newobj.m_parallelgroup_sketchpts2sketchpts = obj.m_parallelgroup_sketchpts2sketchpts(maskusepts,maskusepts);
end

newobj.m_segid_per_candpivot = obj.m_segid_per_candpivot(:,maskusecandpivots);
newobj.m_seglbs_per_sketchpts = obj.m_seglbs_per_sketchpts(maskusepts);

mask = false(size(obj.m_sketchimg));
mask(indsuse) = true;
newobj.m_gdx(~mask) = 0;
newobj.m_gdy(~mask) = 0;
newobj.m_sketchimg = obj.m_sketchimg & mask;

if ~isempty(obj.m_symask_candpivot2candpivot)
    newobj.m_symask_candpivot2candpivot  = obj.m_symask_candpivot2candpivot(maskusecandpivots,maskusecandpivots);
end

obj = newobj;

end

