function obj = set_candpivot_by_seglist( obj, seglist, database, varargin )
% update candpivot by seglist

% set candpivot
candpivots = cellfun(@(x)x.centerpos_sketch(:),seglist,'uniformoutput',false);
candpivots = cat(2,candpivots{:});
obj.m_candpivots = candpivots;

% compute cover
ptsketch = obj.ptsketch;
dirskech = obj.gdxy;
kdsketch = KDTreeSearcher(ptsketch');
% covermat_seg2seglbs = false(length(seglist),max(obj.m_seglbs_per_sketchpts));
covermat_seg2sketchpts = false(length(seglist),size(obj.m_cxpts,2));
for i=1:length(seglist)
    seg = seglist{i};
    ptseg = seg.ptsketch;
    dirseg = seg.gdxy;
    
    % cover from segment to sketch
    covermat_segpts2sketch = srec_cover_pts2pts(ptseg,dirseg,ptsketch,dirskech,'kdto',kdsketch);
    
    % see which seglb in sketch is covered
    maskcover = full(any(covermat_segpts2sketch,1));
    lbscover = srec_cover_refine_by_segment(obj.m_seglbs_per_sketchpts,maskcover);
    maskcover = ismember(obj.m_seglbs_per_sketchpts,lbscover);
    covermat_seg2sketchpts(i,:) = maskcover;
end
obj.m_candpivot2cxpts = covermat_seg2sketchpts;

% update dftransmat
obj.m_dftransmat_per_candpivot = cellfun(@(x)x.m_transmat_sketch_deform,seglist,'uniformoutput',false);

% update match score
mscore = zeros(1,length(seglist));
for i=1:length(seglist)
    if ~isempty(seglist{i}.m_matchscore)
        mscore(i) = seglist{i}.m_matchscore;
    end
end
obj.m_matchscore_per_candpivot = mscore;

% update seg id
segids = cellfun(@(x)x.segid(:),seglist,'uniformoutput',false);
segids = cat(2,segids{:});
obj.m_segid_per_candpivot = segids;

% symask
obj.m_symask_candpivot2candpivot = false(length(seglist),length(seglist));

% lbs
obj.m_lbs_per_candpivot = cellfun(@(x)x.m_label,seglist);

% update others
obj = obj.update_feature_with_candpivot(database);
obj = obj.match_to_database_by_context(database);

end

