function obj = match_to_database_by_fit(obj,database,varargin)
% perform matching for each dbobj
pp = inputParser;
pp.KeepUnmatched = true;
pp.addParamValue('segids',[]); %only match specific segments
pp.parse(varargin{:});

if isempty(pp.Results.segids)
    seglist = cat(2,database.segmentlist_per_label{:});
else
    segids = pp.Results.segids;
    seglist = util_get_segment_by_segids(segids,database);    
end
matchdata = srec_fit_segment_to_sketch_fullsearch(seglist,obj,pp.Unmatched);
matchdatalist = {matchdata};

obj.m_matchdatalist = matchdatalist;
obj.m_dblbs = database.m_labels;
obj.m_maxdgmat = database.m_struct_graph.get_maxdegree_info;

end


