function obj = match_to_database_by_context(obj,database)

%cxpts means candpivots in this function
qr_cxpts = obj.m_candpivots;
nqr_cxpts = size(qr_cxpts,2);

qr_lbs_per_cxpts = obj.m_lbs_per_candpivot;

qr_cxcubes_ldir = obj.m_cxcubes_per_candpivot_ldir;
qr_cxcubes_label = obj.m_cxcubes_per_candpivot_label;

db_lbs = database.m_labels;
ndb_lbs = length(db_lbs);
db_cxcubelistlist_ldir = database.m_cxcubelistlist_ldir;
db_cxcubelistlist_label = database.m_cxcubelistlist_label;

% weight the cxcubes
qr_cxcubes_ldir = weight_by_dist(qr_cxcubes_ldir);
qr_cxcubes_label = weight_by_dist(qr_cxcubes_label);
db_cxcubelistlist_ldir = cellfun(@(x)weight_by_dist(x),db_cxcubelistlist_ldir,'uniformoutput',false);
db_cxcubelistlist_label = cellfun(@(x)weight_by_dist(x),db_cxcubelistlist_label,'uniformoutput',false);

% normalize cxcubes
qr_cxcubes_ldir = srec_normalize_cxcube(qr_cxcubes_ldir);
qr_cxcubes_label = srec_normalize_cxcube(qr_cxcubes_label);
db_cxcubelistlist_ldir = cellfun(@(x)srec_normalize_cxcube(x),db_cxcubelistlist_ldir,'uniformoutput',false);
db_cxcubelistlist_label = cellfun(@(x)srec_normalize_cxcube(x),db_cxcubelistlist_label,'uniformoutput',false);

% match line direction context
scores_per_cxpts_ldir = zeros(1,nqr_cxpts);
[~,idxqrlb2idxdblb] = ismember(qr_lbs_per_cxpts,db_lbs);
for i=1:nqr_cxpts
    query_cxcube = qr_cxcubes_ldir{i};
    k = idxqrlb2idxdblb(i);
    dbcxcubes = db_cxcubelistlist_ldir{k};
    scores = zeros(1,length(dbcxcubes));
    for u=1:length(dbcxcubes)
        dp = query_cxcube.*dbcxcubes{u};
        scores(u) = sum(dp(:));
    end
    if isempty(scores) %database does not have any object containing parts labeled with this
        scores = 0;
    end
    scores_per_cxpts_ldir(i) = max(scores);
end

% match label context
scores_per_cxpts_label = zeros(1,nqr_cxpts);
for i=1:nqr_cxpts
    query_cxcube = qr_cxcubes_label{i};
    k = idxqrlb2idxdblb(i);
    dbcxcubes = db_cxcubelistlist_label{k};
    scores = zeros(1,length(dbcxcubes));
    for u=1:length(dbcxcubes)
        dp = query_cxcube.*dbcxcubes{u};
        scores(u) = sum(dp(:));
    end
    if isempty(scores) %database does not have any object containing parts labeled with this
        scores = 0;
    end
    scores_per_cxpts_label(i) = max(scores);
end

w = 1e-3;
obj.m_cxscore_per_candpivot_label = scores_per_cxpts_label + w;
obj.m_cxscore_per_candpivot_ldir = scores_per_cxpts_ldir + w;

end

function cxcubelist = weight_by_dist(cxcubelist)
if isempty(cxcubelist)
    return;
end

tmpcxcube = cxcubelist{1};
ndist = size(tmpcxcube,2);
ntheta = size(tmpcxcube,1);
nlabel = size(tmpcxcube,3);
ws = (ndist:-1:1).^2;
ws = ws/sum(ws);
ws = repmat(ws(:)',[ntheta,1,nlabel]);
% ws = repmat(ws,[1,1,nlabel]);
for i=1:length(cxcubelist)
    cxcubelist{i} = cxcubelist{i}.*ws;
end

end

function obj = match_to_database_by_context_old(obj,database)

qr_cxpts = obj.m_candpivots;
nqr_cxpts = size(qr_cxpts,2);
qr_cxcubes_ldir = obj.m_cxcubes_per_candpivot_ldir;
qr_cxcubes_label = obj.m_cxcubes_per_candpivot_label;

db_lbs = database.m_labels;
ndb_lbs = length(db_lbs);
db_cxcubelistlist_ldir = database.m_cxcubelistlist_ldir;
db_cxcubelistlist_label = database.m_cxcubelistlist_label;

% normalize cxcubes
qr_cxcubes_ldir = srec_normalize_cxcube(qr_cxcubes_ldir);
qr_cxcubes_label = srec_normalize_cxcube(qr_cxcubes_label);
db_cxcubelistlist_ldir = cellfun(@(x)srec_normalize_cxcube(x),db_cxcubelistlist_ldir,'uniformoutput',false);
db_cxcubelistlist_label = cellfun(@(x)srec_normalize_cxcube(x),db_cxcubelistlist_label,'uniformoutput',false);

% match line direction context
scoremap_cx_ldir = zeros(ndb_lbs,nqr_cxpts);
for i=1:nqr_cxpts
    query_cxcube = qr_cxcubes_ldir{i};
    for k=1:ndb_lbs
        dbcxcubes = db_cxcubelistlist_ldir{k};
        scores = zeros(1,length(dbcxcubes));
        for u=1:length(dbcxcubes)
            dp = query_cxcube.*dbcxcubes{u};
            scores(u) = sum(dp(:));
        end
        if isempty(scores) %database does not have any object containing parts labeled with this
            scores = 0;
        end
        scoremap_cx_ldir(k,i) = max(scores);
    end
end

% match label contex 
scoremap_cx_label = zeros(ndb_lbs,nqr_cxpts);
for i=1:nqr_cxpts
    query_cxcube = qr_cxcubes_label{i};
    for k=1:ndb_lbs
        dbcxcubes = db_cxcubelistlist_label{k};
        scores = zeros(1,length(dbcxcubes));
        for u=1:length(dbcxcubes)
            dp = query_cxcube.*dbcxcubes{u};
            scores(u) = sum(dp(:));
        end
        if isempty(scores) %database does not have any object containing parts labeled with this
            scores = 0;
        end
        scoremap_cx_label(k,i) = max(scores);
    end
end

obj.m_cxscoremap_per_candpivot_label=scoremap_cx_label;
obj.m_cxscoremap_per_candpivot_ldir=scoremap_cx_ldir;

end

