function obj = init_with_vecimg( vecimg,varargin )
% rasterize a sketch with vector input
% the vector image should have all points in image coordinate

pp = inputParser;
pp.addParamValue('opt',SBSRSKETCHOPT.default_for_vector);
pp.parse(varargin{:});
skopt = pp.Results.opt;
imgsize = vecimg.m_imgsize;

%% break up the curves into segments
npts = size(vecimg.m_pts,2);
seglabels = zeros(0,npts);
if skopt.m_breakseg_by_arclength
    seglabels(end+1,:) = vecimg.m_segby_arclen;
end

if skopt.m_breakseg_by_corner
    seglabels(end+1,:) = vecimg.m_segby_line;
end

if skopt.m_breakseg_by_intersection
    seglabels(end+1,:) = vecimg.m_segby_intersect;
    seglabels(end+1,:) = vecimg.m_segby_junction;
end

% mark the curve
%for two pixel has one kind of label different, they belong to different segment
%a subseg is what later becomes a seglbs
[~,~,seglbs] = unique(seglabels','rows'); 
seglbs = SBSRVECIMAGE.cleanup_short_seglbs(seglbs,vecimg.m_segby_stroke);
[~,~,seglbs] = unique(seglbs);
seglbs = seglbs(:)';

% figure;
% util_scatter_pts_typed(vecimg.m_pts,seglbs);

% break the curve
[newptslist,newdirlist,idxlist] = vecimg.pts_by_type(seglbs,'include_endpts',true);
nsubseg = length(newptslist); %newptslist{i} = points if ith subseg
pargroupid_per_subseg = zeros(1,nsubseg);
segcontgroup_per_subseg = zeros(1,nsubseg);
for i=1:length(idxlist)
    idx = idxlist{i};
    pgvals = vecimg.m_segby_parallel_group(idx);
    pargroupid_per_subseg(i) = mode(pgvals);
    segcontgroup_per_subseg(i) = mode(vecimg.m_segby_stroke(idx));
end
seglbs_per_subseg = 1:nsubseg;

segtiming_per_subseg = zeros(1,nsubseg);
for i=1:vecimg.nstroke
    mask = segcontgroup_per_subseg == i;
    dt = 0.01;
    segtiming_per_subseg(mask) = i+(dt:dt:dt*nnz(mask));
end

%% rasterize curves in image
sketchimg = false(imgsize);
seqmap = zeros(imgsize);
maxseqnum = 0;
seglbsmap = zeros(imgsize);
gdx = zeros(imgsize);
gdy = zeros(imgsize);
imgpts_per_subseg = cell(1,length(newptslist));
for i=1:length(newptslist)
    ptsample = newptslist{i};
    dirsample = newdirlist{i};
%     mask = util_rasterize_polyline(ptsample,imgsize);
    
    [imgpts,mask] = util_rasterize_polyline_bresenham(ptsample,imgsize);
    mask = srec_skeletonize_sketch(mask);
    ptsuse = util_pts_from_bwimg(mask);
    tf = ismember(imgpts',ptsuse','rows');
    imgpts = imgpts(:,tf);
    assert(isequal(sort(imgpts,2),sort(ptsuse,2)));
    inds = sub2ind(imgsize,imgpts(1,:),imgpts(2,:));
    seqmap(inds) = maxseqnum+(1:length(inds));
    maxseqnum = maxseqnum + length(inds);
    
    % for each rasterized point, find the closest sample and use its
    % tangent as the sample tangent
    [is,js] = find(mask);
    ptsuse = [is(:),js(:)]';
    idxsample = knnsearch(ptsample',ptsuse');
    diruse = dirsample(:,idxsample);
    
    [~,idxsort] = sort(idxsample);
    imgpts_per_subseg{i} = ptsuse(:,idxsort);
    
    idx = find(mask);
    sketchimg(idx) = true;
    seglbsmap(idx) = seglbs_per_subseg(i);
    gdx(idx) = diruse(1,:);
    gdy(idx) = diruse(2,:);
end

% filter imgpts_per_subseg because some points may have been covered by
% other seglbs
for i=1:length(imgpts_per_subseg)
    pts = imgpts_per_subseg{i};
    inds = sub2ind(size(seglbsmap),pts(1,:),pts(2,:));
    seglbs = seglbsmap(inds);
    pts = pts(:,seglbs == i);
    imgpts_per_subseg{i} = pts;
end

obj = SBSRSKETCH;
obj.m_vecpts_per_seglb = newptslist;
obj.m_vecdirs_per_seglb = newdirlist;
obj.m_imgpts_per_seglb = imgpts_per_subseg;
obj.m_seqmap = seqmap;

[is,js] = find(sketchimg);
ptsketch = [is(:) js(:)]';
obj.m_cxpts = ptsketch;
obj.m_datafile = vecimg.m_datafile;
obj.m_gdx = gdx;
obj.m_gdy = gdy;
obj.m_original_sketchimg = sketchimg;

% continuity grouping
nseglb = max(seglbs_per_subseg);
segcontmat = zeros(nseglb,nseglb);
ncontgroup = max(segcontgroup_per_subseg);
for i=1:ncontgroup
    maskingroup = segcontgroup_per_subseg == i;
    seglbs = seglbs_per_subseg(maskingroup);
    segcontmat(seglbs,seglbs) = i;
end
obj.m_segcontgroup_seglb2seglb = segcontmat;

% parallel grouping
if skopt.m_use_parallel_group
    nseglb = max(seglbs_per_subseg);
    pargroupadjmat = zeros(nseglb,nseglb);
    npargroup = max(pargroupid_per_subseg);
    for i=1:npargroup
        maskingroup = pargroupid_per_subseg == i;
        seglbs = seglbs_per_subseg(maskingroup);
        pargroupadjmat(seglbs,seglbs) = i;
    end
    obj.m_parallelgroup_seg2seg = pargroupadjmat;
end

% straight line decomposition
pts_per_line = vecimg.pts_by_line;
obj.m_vecpts_per_line = pts_per_line;

lineidx = cell(1,length(pts_per_line));
for i=1:length(pts_per_line)
    lineidx{i} = repmat(i,1,size(pts_per_line{i},2));
end
lineidx = cat(2,lineidx{:});
pts = cat(2,pts_per_line{:});
imgpts = util_pts_from_bwimg(sketchimg);
idx = knnsearch(pts',imgpts');
lineidx_per_imgpts = lineidx(idx);
imgpts_per_line = cell(1,length(pts_per_line));
for i=1:length(pts_per_line)
    thisidx = lineidx_per_imgpts == i;
    thisimgpts = imgpts(:,thisidx);
    
    % sort the points
    thislinepts = pts_per_line{i};
    idx = knnsearch(thislinepts',thisimgpts');
    [~,idxsort] = sort(idx);
    thisimgpts = thisimgpts(:,idxsort);
    
    imgpts_per_line{i} = thisimgpts;
end
obj.m_imgpts_per_line = imgpts_per_line;

seglbs_per_sketchpts = seglbsmap(sketchimg);
obj.m_seglbs_per_sketchpts = seglbs_per_sketchpts(:)';
obj.m_segtimes = segtiming_per_subseg;
obj.m_sketchimg = sketchimg;
obj.m_vecimg = vecimg;

obj.m_sketchopt = skopt;

% sequence stroke points
obj = srec_sequence_stroke_pts(obj);
obj.m_dblbs = vecimg.m_dblbs;

% view
obj.m_view = vecimg.m_view;
obj.m_view_manual = vecimg.m_view;

% symplane
obj.m_symplane_normal = vecimg.symplane_normal;
obj.m_symplane_p0 = vecimg.symplane_p0;

% %% ground truth labeling
% if ~isempty(vecimg.m_idxpts_per_label)
%     obj.m_dblbs = vecimg.m_dblbs;
%     imgpts = util_pts_from_bwimg(obj.m_sketchimg);
%     kdsketch = KDTreeSearcher(imgpts');
%     lbs2sketchpts = false(length(vecimg.m_dblbs),size(imgpts,2));
%     for i=1:length(vecimg.m_idxpts_per_label)
%         pts = vecimg.pts(:,vecimg.m_idxpts_per_label{i});
%         
%         % vector points cover what points in image?
%         [idxsketchpts,distlist] = kdsketch.knnsearch(pts');
%         maskuse = distlist<=2;
%         idxsketchpts = idxsketchpts(maskuse);
%         lbs2sketchpts(i,idxsketchpts) = true;
%     end
%     [~,idxsketchpts_per_label] = util_complete_label_assignment(imgpts,lbs2sketchpts);
%     
%     inds = find(obj.m_sketchimg);
%     inds_per_label = cell(1,length(vecimg.m_dblbs));
%     for i=1:length(idxsketchpts_per_label)
%         idx = idxsketchpts_per_label{i};
%         thisinds = inds(idx);
%         inds_per_label{i} = thisinds;
%     end
%     obj.m_inds_per_dblbs = inds_per_label;
% end

%% ground truth segmentation and labeling
if ~isempty(vecimg.m_idxpts_per_obj)
    imgpts = util_pts_from_bwimg(obj.m_sketchimg);
    nobj = length(vecimg.m_idxpts_per_obj);
    kdsketch = KDTreeSearcher(imgpts');
    lbs2sketchpts = false(nobj,size(imgpts,2));
    for i=1:length(vecimg.m_idxpts_per_obj)
        pts = vecimg.pts(:,vecimg.m_idxpts_per_obj{i});
        
        % vector points cover what points in image?
        [idxsketchpts,distlist] = kdsketch.knnsearch(pts');
        maskuse = distlist<=2;
        idxsketchpts = idxsketchpts(maskuse);
        lbs2sketchpts(i,idxsketchpts) = true;
    end
    [~,idxsketchpts_per_obj] = util_complete_label_assignment(imgpts,lbs2sketchpts);
    
    inds = find(obj.m_sketchimg);
    inds_per_obj = cell(1,nobj);
    for i=1:length(idxsketchpts_per_obj)
        idx = idxsketchpts_per_obj{i};
        thisinds = inds(idx);
        inds_per_obj{i} = thisinds;
    end
    obj.m_inds_per_component = inds_per_obj;
    obj.m_label_per_component = vecimg.m_label_per_obj;
end
end

function show_ptsmarklist(ptsmarklist,breakid)
return;
if nargin == 1
    breakid = 5;
end
seglist = {};
for i=1:length(ptsmarklist)
    pts = ptsmarklist{i};
    tt = break_pts_into_segments(pts(1:2,:),pts(breakid,:)>0);
    seglist = cat(2,seglist,tt);
end

figure;hold on;
for i=1:length(seglist)
    hold on;
    pts = seglist{i};
    util_scatter_pts(pts,util_marker(i,GLOBALCONST.PLOT_DIFF_MARKER_LIST));
end
end







