function obj = init_with_sketchimg( sketchimg,varargin )

pp = inputParser;
pp.addParamValue('opt',SBSRSKETCHOPT.default_for_raster);
pp.parse(varargin{:});

skopt = pp.Results.opt;

obj = SBSRSKETCH;

% clear image boundary
mask = false(size(sketchimg));
mask(2:end-1,2:end-1) = true;
sketchimg(~mask) = false;

skimg = srec_skeletonize_sketch(sketchimg);
obj.m_sketchimg = skimg;

fprintf(1,'SKETCH: calculating gradient...\n');
[is js] = find(sketchimg);
pts = [is(:) js(:)]';
boxlens = util_make_aabb_from_pts(pts);
npixsmooth = round(norm(boxlens)*GLOBALCONST.THRES_NPIXSMOOTH_TO_DIAG);
if npixsmooth < 3
    npixsmooth = 0;
end
[dx,dy] = util_skeleton_gradient(skimg,npixsmooth);
obj.m_gdx = dx;
obj.m_gdy = dy;

% find segment group
fprintf(1,'SKETCH: grouping by line segment...\n');
seglist = util_skeleton_to_line_segment(skimg);
% seglist = util_merge_sketch_segments(seglist,skimg);
lbsmap = zeros(size(sketchimg));
for i=1:length(seglist)
    sg = seglist{i};
    lbsmap(sg) = i;
end
obj.m_seglbs_per_sketchpts = lbsmap(skimg);
obj = srec_fix_0seglbs(obj);

% find parallel group
if skopt.m_use_parallel_group
    fprintf(1,'SKETCH: grouping by parallel lines...\n');
    idxpix = find(skimg);
    pixpairs = srec_pixgroup_parallel_from_sketch(skimg);
    [~,pixpairs(1,:)] = ismember(pixpairs(1,:),idxpix);
    [~,pixpairs(2,:)] = ismember(pixpairs(2,:),idxpix);
    adjmat = sparse(pixpairs(1,:),pixpairs(2,:),true,nnz(skimg),nnz(skimg))>0;
    adjmat = adjmat | adjmat';
    obj.m_parallelgroup_sketchpts2sketchpts = adjmat;
end

obj.m_sketchopt = skopt;

fprintf(1,'SKETCH: done\n');

end

