function [imgsize,npixlong,vecimg] = imgsize_from_database( vecimg, database,varargin )
% find how to scale the vector image based on database examples
pts = vecimg.m_pts;
boxlens_svg = util_make_aabb_from_pts(pts);
ar = boxlens_svg(1)/boxlens_svg(2);

% find example in database with closest h/w ratio
K = 5;
dbobjlist = database.m_dbobjlist;
ars_db = zeros(1,length(dbobjlist));
boxlens_db = zeros(2,length(dbobjlist));
for i=1:length(dbobjlist)
    dbobj = dbobjlist{i};
    dbsketch = dbobj.get_sketch;
    [is,js] = find(dbsketch);
    dbaabb = util_make_aabb_from_pts([is(:) js(:)]');
    ars_db(i) = dbaabb(1)/dbaabb(2);
    boxlens_db(:,i) = dbaabb;
end
idxhit = knnsearch(ars_db(:),ar,'K',K);
boxlens_expected = mean(boxlens_db(:,idxhit),2);

scalef = min(boxlens_expected./boxlens_svg(:));
pts = pts * scalef;
boxlens_svg_new = util_make_aabb_from_pts(pts);

npixlong = ceil(max(boxlens_svg_new));
imgsize = database.m_dbobjlist{1}.imgsize;

vecimg = vecimg.set_transmat_by_imgc(imgsize,npixlong);
end

