function pts_per_stroke = get_stroke_pts( obj )
if isempty(obj.m_imgpts_per_stroke)
    segcontgroups = obj.segcontgroups;
    nstroke = length(segcontgroups);
    pts_per_stroke = cell(1,nstroke);
    for i=1:nstroke
        seglbs = segcontgroups{i};
        ptslist = obj.m_imgpts_per_seglb(seglbs);
        pts = cat(2,ptslist{:});
        pts_per_stroke{i} = pts;
    end
else
    pts_per_stroke = obj.m_imgpts_per_stroke;
end

end

