function [inds_stroke2stroke,pts_stroke2stroke,distmat] = get_stroke2stroke_link(obj)
segcontgroups = obj.segcontgroups;
pts2ind = @(pts)sub2ind(size(obj.m_sketchimg),pts(1,:),pts(2,:));

nstroke = length(segcontgroups);
kdtree_per_stroke = cell(1,nstroke);
pts_per_stroke = obj.get_stroke_pts;
for i=1:nstroke
    pts = pts_per_stroke{i};
    kdtree_per_stroke{i} = KDTreeSearcher(pts');
end

inds_stroke2stroke = zeros(nstroke,nstroke,2);
pts_stroke2stroke = nan(nstroke,nstroke,4);
distmat = inf(nstroke,nstroke);
ptsketch = util_pts_from_bwimg(obj.m_sketchimg);
boxlens = util_make_aabb_from_pts(ptsketch);
thres_mindist = norm(boxlens) * 0.05;

for i=1:nstroke
    for j=1:nstroke
        if i==j
            continue;
        end
        
        si = pts_per_stroke{i};
        sj = pts_per_stroke{j};
        
        if isempty(si) || isempty(sj)
            continue;
        end
        kdj = kdtree_per_stroke{j};
        
        pi1 = si(:,1);
        pi2 = si(:,end);
        
        [idxj,dist] = kdj.knnsearch([pi1,pi2]');
        pj1 = sj(:,idxj(1));
        d1 = dist(1);
        if d1<=thres_mindist
            pts_stroke2stroke(i,j,:) = [pi1;pj1];
            inds_stroke2stroke(i,j,:) = pts2ind([pi1,pj1]);
            distmat(i,j) = d1;
        end
        
        pj2 = sj(:,idxj(2));
        d2 = dist(2);
        if d2<=thres_mindist && d2<d1
            pts_stroke2stroke(i,j,:) = [pi2;pj2];
            inds_stroke2stroke(i,j,:) = pts2ind([pi2,pj2]);
            distmat(i,j) = d2;
        end
    end
end


end

