function [inds_seglb2seglb,pts_seglb2seglb] = get_seglb2seglb_link( obj )
[is,js] = find(obj.m_sketchimg);
ptsketch = [is(:),js(:)]';

indsmap = zeros(size(obj.m_sketchimg));
inds = find(obj.m_sketchimg);
indsmap(inds) = inds;

segcontgroups = obj.segcontgroups;
nseglb = max(obj.m_seglbs_per_sketchpts);
pts_seglb2seglb = nan(nseglb,nseglb,4);
inds_seglb2seglb = zeros(nseglb,nseglb,2);

for i=1:length(segcontgroups)
    seglbs = segcontgroups{i};
    if length(seglbs) < 2
        continue;
    end
    
    for k=1:length(seglbs)-1
        s1 = seglbs(k);
        mask1 = obj.m_seglbs_per_sketchpts == s1;
        pts1 = ptsketch(:,mask1);
        
        s2 = seglbs(k+1);
        mask2 = obj.m_seglbs_per_sketchpts == s2;
        pts2 = ptsketch(:,mask2);
        
        [idx,dist] = knnsearch(pts1',pts2');
        [~,idx2] = min(dist); %the closest point at pts2
        idx1 = idx(idx2); %the closest point at pts1
        
        p1 = pts1(:,idx1);
        p2 = pts2(:,idx2);
        pts_seglb2seglb(s1,s2,:) = [p1;p2];
        pts_seglb2seglb(s2,s1,:) = [p2;p1];
        
        ind1 = indsmap(p1(1),p1(2));
        ind2 = indsmap(p2(1),p2(2));
        inds_seglb2seglb(s1,s2,:) = [ind1,ind2];
        inds_seglb2seglb(s2,s1,:) = [ind2,ind1];
    end
end

end


