function [val,idxcandpivot_label2cxpts] = get_scoremap_label2cxpts(obj)
% calculate by multiplying matching and context scoremap

adjmat_candpivot2cxpts = obj.m_candpivot2cxpts;
lbs_per_candpivot = obj.m_lbs_per_candpivot;
scores_per_candpivot = obj.get_candpivot_scores;

dblbs = obj.m_dblbs;
ncxpts = size(adjmat_candpivot2cxpts,2);
npivots = size(adjmat_candpivot2cxpts,1);
scoremap_label2cxpts = zeros(length(dblbs),ncxpts);
idxcandpivot_label2cxpts = zeros(length(dblbs),ncxpts);
[~,loclb] = ismember(lbs_per_candpivot,dblbs);
for i=1:npivots
    thislb = lbs_per_candpivot(i);
    idxlb = loclb(i);
    maskcxpts = adjmat_candpivot2cxpts(i,:);
    pvscore = scores_per_candpivot(i);
    oldscore = scoremap_label2cxpts(idxlb,maskcxpts);
    newscore = max(oldscore,pvscore);
    scoremap_label2cxpts(idxlb,maskcxpts) = newscore;
    
    % these slots have been override
    idxcandpivot_label2cxpts(thislb,newscore==pvscore) = i;
end

val = scoremap_label2cxpts;

end