function scoremap = get_scoremap_by_pts( scoremaplist, scoremaplbs, pts,labels )
% compose a scoremap so that scoremap(i,j) is for pts(:,j) and labels(i)

assert(length(unique(scoremaplbs)) == length(scoremaplbs), 'each label should have only one scoremap');

scoredata = scoremaplist;
lbs_per_scoredata = scoremaplbs;

idxpts = sub2ind(size(scoremaplist{1}),pts(1,:),pts(2,:));
scoremap = zeros(length(labels),size(pts,2));
[tf,loc] = ismember(labels,lbs_per_scoredata);
for i=1:length(labels)
    idxscoremap = loc(i);
    if idxscoremap == 0
        continue;
    end
    thiscoredata = scoredata{idxscoremap};
    score_per_pts = thiscoredata(idxpts);
    scoremap(i,:) = score_per_pts;
end

end

