function [scoremap,xymat] = get_matchinfo_by_pts(obj,labels,pts)
% get match information for a set of points
% scoremap(i,j) = score of pts(:,j) for labels(i)
% xymat(i,j,:) = position of the component for scoremap(i,j)

scoredata = obj.m_match_scoremaps;
lbs_per_scoredata = obj.m_label_per_match_scoremap;
xymat_per_scoredata = obj.m_xymat_per_match_scoremap;

idxpts = sub2ind(size(obj.m_sketchimg),pts(1,:),pts(2,:));
scoremap = zeros(length(labels),size(pts,2));
xymat = zeros(length(labels),size(pts,2),2);
[tf,loc] = ismember(labels,lbs_per_scoredata);
for i=1:length(labels)
    % index of the scoremap for labels(i)
    idxscoremap = loc(i);
    if idxscoremap == 0
        continue;
    end
    
    % get score for labels(i)
    thiscoredata = scoredata{idxscoremap};
    score_per_pts = thiscoredata(idxpts);
    scoremap(i,:) = score_per_pts;
    
    % get xymat for labels(i)
    thisxymatdata = xymat_per_scoredata{idxscoremap};
    xmat = thisxymatdata(:,:,1);
    ymat = thisxymatdata(:,:,2);
    xymat(i,:,1) = xmat(idxpts);
    xymat(i,:,2) = ymat(idxpts);
end


end

