function [lbmap,lbmask_per_dblbs] = get_lbmap_from_segmentation( obj )
% get label map from groundtruth segmentation with labels
% lbmap = a label map, note that some segment may overlap, making the label
% map imperfect
% lbmask_per_dblbs{i} is the label mask for dblbs(i)

inds_per_comp = obj.m_inds_per_component;
label_per_comp = obj.m_label_per_component;
imgsize = size(obj.m_sketchimg);

lbmap = zeros(imgsize);
lbmask_per_dblbs = repmat({false(imgsize)},1,length(obj.m_dblbs));
for i=1:length(inds_per_comp)
    inds = inds_per_comp{i};
    thislb = label_per_comp(i);
    lbmap(inds) = thislb;
    
    lbmask_per_dblbs{obj.m_dblbs == thislb}(inds) = true;
end

% extend lbmap to uncovered pixels
mask_has_label = lbmap > 0;
[~,L] = bwdist(mask_has_label);
lbmap_extend = reshape(lbmap(L),imgsize);
lbmap_extend = lbmap_extend .* double(obj.m_sketchimg);
lbmap = lbmap_extend;

% filter each mask
lbmask_per_dblbs = cellfun(@(x)x&obj.m_sketchimg,lbmask_per_dblbs,'uniformoutput',false);

end

