function [lbmap,adjmat_seglb2pixel] = get_groundtruth_segmentation( obj )
% lbmap(i,j) == k iff pixel (i,j) belongs to segment k
% seglb2pixel(i,j) == 1 iff pixel j belongs to segment i

inds_per_comp = obj.m_inds_per_component;
lbmap = zeros(size(obj.m_sketchimg));
adjmat_seglb2pixel = false(length(inds_per_comp),nnz(obj.m_sketchimg));

for i=1:length(inds_per_comp)
    inds = inds_per_comp{i};
    lbmap(inds) = i;
    lbmask = lbmap == i;
    adjmat_seglb2pixel(i,:) = lbmask(obj.m_sketchimg);
end



end

