function [lbmap,adjmat_label2pixel] = get_groundtruth_lbmap( obj,lbs )
% lbmap(i,j) = the label of pixel (i,j)
% adjmat_label2pixel(i,j) == 1 iff pixle j belongs to label obj.m_dblbs(i)
if nargin < 2
    lbs = obj.m_dblbs;
end
lbmap = zeros(size(obj.m_sketchimg));
npix = nnz(obj.m_sketchimg);
nlbs = length(obj.m_dblbs);

adjmat_label2pixel = zeros(nlbs,npix);

inds_per_comp = obj.m_inds_per_component;
lbs_per_comp = obj.m_label_per_component;
[lbs_per_comp,idxsort] = sort(lbs_per_comp);
inds_per_comp = inds_per_comp(idxsort);

for i=1:length(inds_per_comp)
    inds = inds_per_comp{i};
    thislb = lbs_per_comp(i);
    if ~ismember(thislb,lbs) || isempty(inds)
        continue;
    end
    lbmap(inds) = thislb;
    lbmask = false(size(lbmap));
    lbmask(inds) = true;
    adjmat_label2pixel(i,:) = lbmask(obj.m_sketchimg);
end

end

