function obj = update_symscore( obj,p0,plnormal )

if nargin == 1
    p0 = obj.m_symplane_p0;
    plnormal = obj.m_symplane_normal;
end

ncompts = size(obj.m_compts,2);
if ~isempty(p0) && ~isempty(plnormal)
    % labels to sym
    lbstosym = GLOBALCONST.LABEL_SYMABLE_IN_CONSTRUCTION;
    masksym = ismember(obj.m_complabels,lbstosym);

    symthres = GLOBALCONST.THRES_MIN_SYMSCORE_ACCEPTABLE;

    maskvalidcompts = obj.maskvalid_compts;
%     ncompts = length(maskvalidcompts);

    idxcompts_needsym = find(maskvalidcompts);
    scoremat_from2to = srec_evaluate_symcompts(obj,...
        idxcompts_needsym,idxcompts_needsym,p0,plnormal);
    symscoremat = zeros(ncompts,ncompts);
    symscoremat(idxcompts_needsym,idxcompts_needsym) = scoremat_from2to;
    symscoremat(symscoremat<symthres) = 0;
    
    % respect known symmetric
    symask = obj.m_symask_comp2comp;
    maskpresym = any(symask,1);
    if any(maskpresym)
        symscoremat(maskpresym,:) = symask(maskpresym,:);
        symscoremat(:,maskpresym) = symask(:,maskpresym);
    end

    symscoremat(~masksym,:) = 0;
    symscoremat(:,~masksym) = 0;
else
    symscoremat = zeros(ncompts,ncompts);
end

obj.m_symscore_comp2comp = symscoremat;
obj.m_symplane_p0 = p0;
obj.m_symplane_normal = plnormal;

% [~,idxmax] = max(scoremat_from2to,2);
% idxcompts_symto = idxcompts_needsym(idxmax);
% compgroup_comp2comp = sparse(idxcompts_needsym,idxcompts_symto,1,...
%     ncompts,ncompts);
% obj.m_groupmat_comp2comp = compgroup_comp2comp;

end

