function obj = update_overlapcost_comp2comp( obj,database )
% a cost induced by component overlapping
% overlapcost(i,j) = min(overlap(i,j)/area(i),overlap(i,j)/area(j))

adjmat_comp2sample = obj.m_adjmat_comp2sample > 0;
nsample_per_comp = sum(adjmat_comp2sample,2);
ncomp = size(adjmat_comp2sample,1);
costmat = zeros(ncomp,ncomp);

% seglist = util_get_segment_by_segids(obj.m_segid_per_compts,database);
% imgsize = size(obj.m_sketchimg);
% compts = obj.m_compts;
% for i=1:length(seglist)
%     sg = seglist{i};
%     sg = sg.set_position_center(compts(:,i));
%     seglist{i} = sg;
% end
% segimglist = util_segment_to_img(seglist,imgsize);

for i=1:ncomp
    irow = adjmat_comp2sample(i,:);
%     iseg = segimglist{i};
    for j=1:i-1
        jrow = adjmat_comp2sample(j,:);
%         jseg = segimglist{j};
        
        overlap_by_sample = nnz(irow & jrow);
        overlap_by_sample = (overlap_by_sample/nnz(irow)+overlap_by_sample/nnz(jrow))/2;
%         overlap_by_sample = max(overlap_by_sample/nnz(irow),overlap_by_sample/nnz(jrow));
%         overlap_by_region = nnz(iseg & jseg);
%         overlap_by_region = (overlap_by_region/nnz(iseg)+overlap_by_region/nnz(jseg))/2;
%         overlap_by_region = max(overlap_by_region/nnz(iseg),overlap_by_region/nnz(jseg));
%         cost = min(overlap_by_sample,overlap_by_region);
        cost = overlap_by_sample;
        costmat(i,j) = cost;
    end
end

costmat(isnan(costmat)) = 0;
costmat = costmat + costmat';

% for i=1:ncomp
%     idxother = [1:i-1,i+1:ncomp];
%     thisrow = adjmat_comp2sample(i,:);
%     otherows = adjmat_comp2sample(idxother,:);
%     ovmask = bsxfun(@times,thisrow,otherows);
%     ovcount = sum(ovmask,2);
%     
%     nsample_this = nsample_per_comp(i);
%     nsample_other = nsample_per_comp(idxother);
% 
%     costmat(i,idxother) = (ovcount./nsample_other + ovcount/nsample_this)/2;
% end

obj.m_overlapcost_comp2comp = costmat;

end

