function obj = update_conflict_cost(obj,database,sketchdata)

fprintf(1,'UPDATE CONFLICT: getting seglist\n');
seglist = srec_seglist_from_solution(1:size(obj.m_compts,2),obj,database);

nseg = length(seglist);
conngraph = database.m_conngraph;
adjmat = true(nseg);

% remove unconnectable components
connectable_lbs2lbs = false(GLOBALCONST.LABEL_MAXVAL);
connectable_lbs2lbs(database.m_labels,database.m_labels) = database.m_conngraph.m_adjmat;
[lbsii,lbsjj] = ndgrid(obj.m_complabels,obj.m_complabels);
idx = sub2ind(size(connectable_lbs2lbs),lbsii(:),lbsjj(:));
connok = connectable_lbs2lbs(idx);
adjmat(:) = connok;
adjmat(eye(nseg)>0) = 0;
obj.m_connectable_by_label_comp2comp = adjmat;

fprintf(1,'UPDATE CONFLICT: getting relpos\n');
relpos = srec_relpos_by_connpts(seglist,adjmat,conngraph,'usesym',true);

dmat2d = relpos.m_movedist2_imgc;
costmat = sqrt(dot(dmat2d,dmat2d,3));
costmat(isnan(costmat)) = inf;

[is js] = find(sketchdata.m_sketchimg);
boxlens = util_make_aabb_from_pts([is(:) js(:)]');
% disthres = norm(boxlens) * GLOBALCONST.THRES_CONFLICT_MIN_MOVMENTDIST_TO_DIAG;
disthres = norm(boxlens) * 0.15;
scoremat = exp(-costmat.^2/(2*disthres.^2));
% scoremat = exp(-costmat/disthres);
% scoremat = double(costmat < disthres);

obj.m_conflictscore_comp2comp = scoremat;
obj.m_conflictscore_comp2comp(obj.m_adjmat_invalid_comp2comp) = 0;
obj.m_structscore_comp2comp = scoremat;
obj.m_structscore_comp2comp(obj.m_adjmat_invalid_comp2comp) = 0;

obj.m_structscore_comp2comp_raw = scoremat;
obj.m_movedist_comp2comp = costmat;
fprintf(1,'UPDATE_CONFLICT:done\n');

end

function obj = update_conflict_cost_old(obj,database,sketchdata)

invalidmask = obj.m_adjmat_invalid_comp2comp;
validmask = ~invalidmask;
validmask(eye(size(validmask))>0)=0;

[is,js] = find(tril(validmask));
ptsfrom = obj.m_compts(:,is);
lbsfrom = obj.m_complabels(is);
segidsfrom = obj.m_segid_per_compts(:,is);
seglistfrom = util_get_segment_by_segids(segidsfrom,database);

% update seglist locations
for i=1:length(seglistfrom)
    seglistfrom{i} = seglistfrom{i}.set_position_center(ptsfrom(:,i));
end

ptsto = obj.m_compts(:,js);
lbsto = obj.m_complabels(js);
segidsto = obj.m_segid_per_compts(:,js);
seglisto = util_get_segment_by_segids(segidsto,database);
for i=1:length(seglisto)
    seglisto{i} = seglisto{i}.set_position_center(ptsto(:,i));
end

% [valconf,maskconf] = srec_conflict_by_pivot_pair(...
%     ptsfrom,lbsfrom,ptsto,lbsto,database,sketchdata);
valconf = zeros(1,length(seglistfrom));
conngraph = database.m_conngraph;
for i=1:length(seglistfrom)
    sgfrom = seglistfrom{i};
    sgto = seglisto{i};
    newposfrom = conngraph.get_candidate_positions_by_segpair(sgfrom,sgto);
%     if isempty(newposfrom)
%         valconf(i) = inf;
%         continue;
%     end
%     posfrom2 = newposfrom(1:2,:);
    newpos2 = newposfrom(1:2,:);
    oldpos2 = sgfrom.m_mesh.position(1:2);
    distlist = pdist2(oldpos2',newpos2');
%     posto2 = sgto.m_mesh.position(1:2);
%     posto2 = sgfrom.m_mesh.position(1:2);
%     distlist = pdist2(posto2',posfrom2');
    mindist1 = min(distlist);
    
    newposto = conngraph.get_candidate_positions_by_segpair(sgto,sgfrom);
    newpos2 = newposto(1:2,:);
    oldpos2 = sgto.m_mesh.position(1:2);
    distlist = pdist2(oldpos2',newpos2');
    
%     posto2 = newposto(1:2,:);
%     posfrom2 = sgfrom.m_mesh.position(1:2);
%     distlist = pdist2(posfrom2',posto2');
    mindist2 = min(distlist);
    mindist = min(mindist1,mindist2);
    valconf(i) = mindist;
end

costmat = accumarray([is(:) js(:)],valconf,size(validmask));
costmat = costmat + costmat';
costmat(~validmask) = inf;

[is js] = find(sketchdata.m_sketchimg);
boxlens = util_make_aabb_from_pts([is(:) js(:)]');
% disthres = norm(boxlens) * GLOBALCONST.THRES_CONFLICT_MIN_MOVMENTDIST_TO_DIAG;
disthres = norm(boxlens) * 0.15;
scoremat = exp(-costmat.^2/(2*disthres.^2));
% scoremat = exp(-costmat/disthres);
% scoremat = double(costmat < disthres);

obj.m_conflictscore_comp2comp = scoremat;
obj.m_structscore_comp2comp = scoremat;

end
