function structscoremap = structscoremap_from_compts(compts,complbs,database)

[xx1 xx2] = ndgrid(compts(1,:),compts(1,:));
[yy1 yy2] = ndgrid(compts(2,:),compts(2,:));
[bb1,bb2] = ndgrid(complbs,complbs);

parentpts = [xx1(:) yy1(:)]';
parentlbs = bb1(:);
childpts = [xx2(:) yy2(:)]';
childlbs = bb2(:);

sgraph = database.m_struct_graph;
probmat = sgraph.get_probs_by_pts(parentpts,parentlbs,childpts,childlbs);
probmat =reshape(probmat,size(xx1));
structscoremap = probmat;

end

