function show_seglist( obj,database,varargin )
% show all candidate segments

pp = inputParser;
pp.KeepUnmatched = true;
pp.addParamValue('label',[]);
pp.parse(varargin{:});

lbs = pp.Results.label;

segids = obj.m_segid_per_compts;
compts = obj.m_compts;
if ~isempty(lbs)
    mask = ismember(obj.m_complabels,lbs);
    segids = segids(:,mask);
    compts = compts(:,mask);
end

seglist = util_get_segment_by_segids(segids,database);
for i=1:length(seglist)
    sg = seglist{i};
    sg = sg.set_position_center(compts(:,i));
    seglist{i} = sg;
end
util_show_seglist(seglist,'norot',false,'wireframe',true,pp.Unmatched);

end

