function show_coverage_by_compts( obj,idxcompts,database,varargin )

pp = inputParser;

% show components of this label only
pp.addParamValue('label',[]);
pp.addParamValue('showcoverpts',true); %show the points in the sketch that are covered?
pp.addParamValue('shownodeform',false); %show the undeformed segments
pp.addParamValue('cover_all_seglbs',[]); %only show components that cover all of these set of sketch segments
pp.addParamValue('topn',[]); %sort components by match score and only show the top n components
pp.addParamValue('covermode','normal',@(x)any(strcmpi(x,{'normal','fullcover','justenough'})));
pp.addParamValue('showidxcompts',false); %show the idxcompts for each segment
pp.parse(varargin{:});

if ~isempty(pp.Results.label)
    tf = ismember(obj.m_complabels(idxcompts),pp.Results.label);
    idxcompts = idxcompts(tf);
end

switch pp.Results.covermode
    case 'normal'
        adjmat_comp2sample = obj.m_adjmat_comp2sample;
    case 'fullcover'
        adjmat_comp2sample = obj.m_adjmat_comp2sample_fullcover;
    case 'justenough'
        adjmat_comp2sample = obj.m_adjmat_comp2sample_justenough;
end

% filter by cover_all_seglbs
if ~isempty(pp.Results.cover_all_seglbs)
    coverseglbs = pp.Results.cover_all_seglbs;
    maskuse = false(1,length(idxcompts));
    for i=1:length(idxcompts)
        seglbs = obj.m_seglbs_per_sample(adjmat_comp2sample(idxcompts(i),:));
        maskuse(i) = all(ismember(coverseglbs,seglbs));
    end
    
    idxcompts = idxcompts(maskuse);
end

% filter by topn score
if ~isempty(pp.Results.topn) && pp.Results.topn ~= inf
    topn = pp.Results.topn;
    compscores = obj.m_compscores(idxcompts);
    [~,idxsort] = sort(compscores,'descend');
    idxuse = idxsort(1:min(length(idxsort),topn));
    idxcompts = idxcompts(sort(idxuse));
end

compts = obj.m_compts(:,idxcompts);
complbs = obj.m_complabels(idxcompts);
adjmat_comp2sample = adjmat_comp2sample(idxcompts,:);

sketchimg = obj.m_sketchimg;
[is js] = find(sketchimg);
pts = [is(:) js(:)]';

hold on;
imshow(~obj.m_sketchimg);

mklist = GLOBALCONST.PLOT_DIFF_MARKER_LIST;
for i=1:length(idxcompts)
    thiscompts = compts(:,i);
    samplepts = pts(:,adjmat_comp2sample(i,:));
    idxmk = mod(i,size(mklist,2))+1;
    thismk = mklist(:,idxmk);
    hold on;
    if pp.Results.showcoverpts
        util_scatter_pts(flipud(samplepts),thismk);
    end
    util_scatter_pts(flipud(thiscompts),thismk); 
end

seglist = srec_seglist_from_solution(idxcompts,obj,database);
npts_per_bds = 20;
for i=1:length(seglist)
    sg = seglist{i};
%     sg = sg.set_position_center(compts(:,i));
    bdslist = bwboundaries(sg.m_sketchfilled);
    idxmk = mod(i,size(mklist,2))+1;
    thismk = mklist(:,idxmk);
    thismk(end+1)='-';
    hold on;
%     util_scatter_pts(flipud(sg.m_sketchpos),'ro');
    for k=1:length(bdslist)
        bdspts = bdslist{k}';
        bdspts = bsxfun(@plus,bdspts,sg.m_sketchpos-1);
        idx = linspace(1,length(bdspts),npts_per_bds);
        idx = unique(round(idx));
        bdspts = bdspts(:,idx);
        hold on;
        plot(bdspts(2,:),bdspts(1,:),thismk);
    end
end

if pp.Results.shownodeform
    segids = obj.m_segid_per_compts(:,idxcompts);
    seglist_nodeform = util_get_segment_by_segids(segids,database);
    for i=1:length(seglist_nodeform)
        sg = seglist_nodeform{i};
        sg = sg.set_position_center(compts(:,i));
        bdslist = bwboundaries(sg.m_sketchfilled);
        idxmk = mod(i,size(mklist,2))+1;
        thismk = mklist(:,idxmk);
        thismk(end+1:end+2)='-.';
        hold on;
        for k=1:length(bdslist)
            bdspts = bdslist{k}';
            bdspts = bsxfun(@plus,bdspts,sg.m_sketchpos-1);
            idx = linspace(1,length(bdspts),npts_per_bds);
            idx = unique(round(idx));
            bdspts = bdspts(:,idx);
            hold on;
            plot(bdspts(2,:),bdspts(1,:),thismk);
        end
    end
end

if pp.Results.showidxcompts
    randist = 2;
    for i=1:size(compts,2)
        x = compts(2,i);
        y = compts(1,i);
        dx = randi([-randist,randist],1);
        dy = randi([-randist,randist],1);        
        str = sprintf('\\color{red}{%d}',idxcompts(i));
        hold on;
        text(x+dx,y+dy,str);
    end
end


end

