function show_compts( obj,varargin )

pp = inputParser;
pp.addParamValue('label',unique(obj.m_complabels)');
pp.addParamValue('idxcompts',1:length(obj.m_complabels));
pp.addParamValue('showscore',true);
pp.addParamValue('showsym',true);
pp.addParamValue('showidxcompts',false);
pp.addParamValue('showall',false); %show unconnectable compts
pp.parse(varargin{:});
showscore = pp.Results.showscore;
showidxcompts = pp.Results.idxcompts;
showlbs = pp.Results.label;
showall = pp.Results.showall;
showsym = pp.Results.showsym;

compts = flipud(obj.m_compts);
complbs = obj.m_complabels;
compscores = obj.m_compscores;
ncompts = length(complbs);

mask1 = ismember(complbs,showlbs);
mask2 = false(1,ncompts);
mask2(showidxcompts) = true;
mask = mask1 & mask2;

if ~showall
    adjmat_invalidmask = obj.m_adjmat_invalid_comp2comp;
    if ~isempty(adjmat_invalidmask)
        validmask = any(~adjmat_invalidmask,1);
        mask = mask & validmask;
    end
end
idxcompts = find(mask);

% compts = compts(:,mask);
% complbs = complbs(mask);
% compscores = compscores(mask);


if isempty(compts)
    return;
end

hold on;
imshow(~obj.m_sketchimg);

if isempty(idxcompts)
    return;
end

if showscore
    srec_show_label_pts(compts(:,idxcompts),complbs(idxcompts),'weight',compscores(idxcompts));
else
    srec_show_label_pts(compts(:,idxcompts),complbs(idxcompts));
end

if pp.Results.showidxcompts
    randist = 3;
    for i=1:length(idxcompts)
        x = compts(1,idxcompts(i));
        y = compts(2,idxcompts(i));
        dx = randi([-randist,randist],1);
        dy = randi([-randist,randist],1);
        str = sprintf('\\color{red}{%d}',idxcompts(i));
        text(x+dx,y+dy,str);
    end
end

if ~isempty(obj.m_symscore_comp2comp)
    symscoremat = obj.m_symscore_comp2comp(idxcompts,:);
    [scores,idxcompts_sym] = max(symscoremat,[],2);
    if showsym
        havesym = scores > 0;
        idxfrom = idxcompts(havesym);
        idxto = idxcompts_sym(havesym);
        util_show_segments(compts(:,idxfrom),compts(:,idxto),'-.');
    end
end

end

