function show_comp2sample( obj, varargin )
% show component to sample connection

pp = inputParser;

% only show compts with these labels
pp.addParamValue('label',obj.m_complabels);

% only show compts of these indices
pp.addParamValue('idxcompts',1:size(obj.m_compts,2));
pp.parse(varargin{:});

uselbs = pp.Results.label;
idxcompts = pp.Results.idxcompts;

samplepts = obj.m_samplepts;
compts = obj.m_compts;
complbs = obj.m_complabels;
adjmat_comp2sample = obj.m_adjmat_comp2sample;

compts = compts(:,idxcompts);
complbs = complbs(idxcompts);
adjmat_comp2sample = adjmat_comp2sample(idxcompts,:);

% change pts xy if needed
hold on;
imshow(~obj.m_sketchimg);
[~,~,tmp] = axis('state');
swapaxis = strcmp(tmp,'ij');
if swapaxis
    samplepts = flipud(samplepts);
    compts = flipud(compts);
end

boxlens = util_make_aabb_from_pts([samplepts compts]);
dzratio = 0.1;
zsample = 0;
dz = norm(double(boxlens))*dzratio;

samplepts_3d = samplepts;
samplepts_3d(3,:)=zsample;

ulbs = unique(complbs);
tf = ismember(ulbs,uselbs);
ulbs = ulbs(tf);
mklist = GLOBALCONST.PLOT_COLOR_MARKER_LIST;

util_scatter_pts(samplepts,mklist(:,end));
for i=1:length(ulbs)
    thislb = ulbs(i);
    maskcompts = complbs == thislb;
    thiscompts = compts(:,maskcompts);
    thiscompts(3,:) = dz*i;
    thismk = mklist(:,i);
    
    % plot compts
    hold on;
    util_scatter_pts(thiscompts,thismk);
    
    % plot connections
    thisadjmat_comp2sample = adjmat_comp2sample(maskcompts,:);
    [is js] = find(thisadjmat_comp2sample);
    
    linecompts = thiscompts(:,is);
    linesamplepts = samplepts_3d(:,js);
    linespec = [thismk(1) '-'];
    
    hold on;
    util_show_segments(linecompts,linesamplepts,linespec);
end
axis equal


end

