function show_comp2comp_candgraph( obj,varargin )
    
pp = inputParser;
pp.addParamValue('adjmat',[]);
pp.parse(varargin{:});
adjmat = pp.Results.adjmat;

if isempty(adjmat)
    scoremat_comp2comp = obj.get_scored_graph;
else
    scoremat_comp2comp = adjmat;
end
compts = obj.m_compts;
compts = flipud(compts);
complbs = obj.m_complabels;
maskuse = any(scoremat_comp2comp,1);

comptsuse = compts(:,maskuse);
scorematuse = scoremat_comp2comp(maskuse,maskuse);
lbsuse = complbs(maskuse);

hold on;
imshow(~obj.m_sketchimg);
srec_show_label_pts(comptsuse,lbsuse);
util_show_graph(scorematuse,comptsuse,'linespec','-');
srec_show_label_pts(comptsuse,lbsuse,'legend',false);

end

