function show_comp2comp( obj, varargin)

pp = inputParser;

% only show compts with these labels
pp.addParamValue('label',obj.m_complabels);
pp.addParamValue('showidxcompts',false);

% only show compts of these indices
pp.addParamValue('adjmat',[]);
pp.parse(varargin{:});

uselbs = pp.Results.label;
adjmat = pp.Results.adjmat;

if isempty(adjmat)
    adjmat_comp2comp = obj.m_adjmat_comp2comp;
    invalidmask_comp2comp = obj.m_adjmat_invalid_comp2comp;
    adjmat_comp2comp(invalidmask_comp2comp) = 0;
else
    adjmat_comp2comp = adjmat;
end

compts = obj.m_compts;

hold on
imshow(~obj.m_sketchimg);
warning('off','MATLAB:graph2d:axis:ObsoleteState');
[~,~,axistype] = axis('state');
swapaxis = strcmp(axistype,'ij');
if swapaxis
    compts = flipud(compts);
end

complbs = obj.m_complabels;

mask_compts_ingraph = any(adjmat_comp2comp,1);
compts_ingraph = compts(:,mask_compts_ingraph);
complbs_ingraph = complbs(mask_compts_ingraph);

if nnz(mask_compts_ingraph) == 0
    return;
end

ulbs = unique(complbs_ingraph);
tf = ismember(ulbs,uselbs);
ulbs = ulbs(tf);
mklist = GLOBALCONST.PLOT_COLOR_MARKER_LIST;
[~,~,~,namelist] = util_get_name_by_label(ulbs);

for i=1:length(ulbs)
    thislb = ulbs(i);
    maskuse = (complbs_ingraph == thislb);
    thiscompts = compts_ingraph(:,maskuse);
    thismk = mklist(:,i);
    
    % plot points
    hold on;
    util_scatter_pts(thiscompts,100,thismk);
end
legend(namelist{:});

% show connections
[is js] = find(adjmat_comp2comp);
hold on;
util_show_segments(compts(:,is),compts(:,js));

% show idxcompts
if pp.Results.showidxcompts
    idxcompts = find(any(adjmat_comp2comp));
    for i=1:length(idxcompts)
        idx = idxcompts(i);
        x = compts(1,idx) + rand() * 3;
        y = compts(2,idx) + rand() * 3;
        hold on;
        text(x,y,num2str(idx));
    end
end

end









