function gmdist = merging_probs(comp_ptscloud)
% probability of merging nearby identical labels
% comp_ptscloud = component's point cloud

varatio = 0.3;
comp_center = mean(comp_ptscloud,2);
comp_ptscloud = bsxfun(@plus,comp_ptscloud,-comp_center); %shift to origin

[pcaframe,pcapts,pcavars] = princomp(comp_ptscloud');
% pcapts = pcapts';

% mincorner = min(pcapts,[],2);
% maxcorner = max(pcapts,[],2);
% boxlens = maxcorner-mincorner;
varlens = pcavars * varatio;

% variance matrix
pcasigma = diag(varlens);
sigma = pcaframe*pcasigma*pcaframe';
gmdist = gmdistribution([0 0],sigma);

end

