function obj = init_with_sketchdata( sketchdata )
% build the samplegraph with matched sketchdata

obj = SBSRSAMPLEGRAPH;

samplepts = sketchdata.m_cxpts;
compts = sketchdata.m_candpivots;
score_per_compts = sketchdata.get_candpivot_scores;
adjmat_sample2comp = sketchdata.m_candpivot2cxpts'>0;
label_per_compts = sketchdata.m_lbs_per_candpivot;
ncompts = size(compts,2);

% adjmat among compts are not known yet
adjmat_comp2comp = zeros(ncompts,ncompts);

obj.m_adjmat_comp2comp = adjmat_comp2comp;
obj.m_adjmat_comp2sample = adjmat_sample2comp';
obj.m_complabels = label_per_compts;
obj.m_compscores = score_per_compts;
obj.m_compts = compts;
obj.m_samplepts = samplepts;
obj.m_segid_per_compts = sketchdata.m_segid_per_candpivot;
obj.m_sketchimg = sketchdata.m_sketchimg;
obj.m_symplane_normal = sketchdata.m_symplane_normal;
obj.m_symplane_p0 = sketchdata.m_symplane_p0;
obj.m_gdx = sketchdata.m_gdx;
obj.m_gdy = sketchdata.m_gdy;
obj.m_seglbs_per_sample = sketchdata.m_seglbs_per_sketchpts;
obj.m_adjmat_comp2sample_fullcover = sketchdata.m_candpivot2cxpts_fullcover;
obj.m_dblbs = sketchdata.m_dblbs;
obj.m_maxdgmat = sketchdata.m_maxdgmat;
obj.m_adjmat_comp2sample_justenough = sketchdata.m_candpivot2cxpts_justenough;
obj.m_adjmat_invalid_comp2comp = false(ncompts,ncompts);

obj.m_dftransmat_per_compts = sketchdata.m_dftransmat_per_candpivot;
if isempty(obj.m_dftransmat_per_compts)
    obj.m_dftransmat_per_compts = repmat({eye(3)},1,ncompts);
end

obj.m_symscore_comp2comp = double(sketchdata.m_symask_candpivot2candpivot);
obj.m_symask_comp2comp = sketchdata.m_symask_candpivot2candpivot;

obj.m_idxcandpivot_in_sketchdata = 1:size(compts,2);
obj = obj.update_compscores(sketchdata);

end

function obj = init_with_sketchdata_old( sketchdata )
% build the samplegraph with matched sketchdata

obj = SBSRSAMPLEGRAPH;
dblbs = sketchdata.m_dblbs;

samplepts = sketchdata.m_cxpts;
[scoremap,xymat] = sketchdata.get_matchinfo_by_pts(dblbs,samplepts);
scoremap = sketchdata.get_scoremap_label2cxpts;

% get unique component pts, make an idx mat so that compts(idxmat(i,j),:)
% is the component pts for samplepts(:,j) at label(i)
xmat=xymat(:,:,1);
ymat=xymat(:,:,2);
compts = cell(1,length(dblbs));
idxmat = zeros(size(xmat));
score_per_compts = cell(1,length(dblbs));
label_per_compts = cell(1,length(dblbs));
for i=1:length(dblbs)
    xs = xmat(i,:);
    ys = ymat(i,:);
    pts = [xs(:) ys(:)]';
    scores = scoremap(i,:);
    [upts,idxuse,idxrep] = unique(pts','rows');
    compts{i} = upts';
    idxmat(i,:) = idxrep;
    if i>1
        %idxrep is index in a row, need to add old counts to make it
        %globally valid
        idxmat(i,:) = idxmat(i,:)+max(idxmat(i-1,:));
    end
    score_per_compts{i} = scores(idxuse);
    label_per_compts{i} = repmat(dblbs(i),1,length(idxuse));
end
compts = cat(2,compts{:});
score_per_compts = cat(2,score_per_compts{:});
label_per_compts = cat(2,label_per_compts{:});

% pts = [xmat(:) ymat(:)]';
% 
% [compts,idxuse,idxmat] = unique(pts','rows');
% compts = compts';
% idxmat = reshape(idxmat,size(xmat));

% construct adjmat between samplepts and compts
nsamplepts = size(samplepts,2);
ncompts = size(compts,2);
adjmat_sample2comp = zeros(nsamplepts,ncompts);
tmp = repmat(1:nsamplepts,size(idxmat,1),1);
sub_sample2comp = cat(1,tmp(:)',idxmat(:)');
idx = sub2ind(size(adjmat_sample2comp),sub_sample2comp(1,:),sub_sample2comp(2,:));
adjmat_sample2comp(idx) = 1;

% adjmat among compts are not known yet
adjmat_comp2comp = zeros(ncompts,ncompts);

obj.m_adjmat_comp2comp = adjmat_comp2comp;
obj.m_adjmat_comp2sample = adjmat_sample2comp';
obj.m_complabels = label_per_compts;
obj.m_compscores = score_per_compts;
obj.m_compts = compts;
obj.m_samplepts = samplepts;

end