function idxcompts_sym = get_symmetric_idxcompts( obj,idxcompts,varargin )
% given a list of components, find their symmetric components
% idxcompts_sym(i) = symmetric component for idxcompts(i), 0 if the
% component has no symmetric component

pp = inputParser;
pp.addParamValue('exact',true); %should we only use exact symmetry? (provided by symask,not symscore)
pp.parse(varargin{:});

if pp.Results.exact
    symscore = double(obj.m_symask_comp2comp);
else
    symscore = obj.m_symscore_comp2comp;
end
[scores,idxmax] = max(symscore(idxcompts,:),[],2);
idxcompts_sym = idxmax;
idxcompts_sym(scores==0) = 0;

% % ignore certain kinds of symmetric
% lbs_ignore_sym = [GLOBALCONST.AIRPLANE_HORISTAB];
% lbs = obj.m_complabels(idxcompts);
% maskignore = ismember(lbs,lbs_ignore_sym);
% idxcompts_sym(maskignore) = 0;

end

