function adjmat = get_scored_graph( obj,varargin )

pp = inputParser;
pp.addParamValue('adjmat',[]); %if specified, use this adjmat
pp.addParamValue('usecompscore',false); %add component matching score into graph?
pp.addParamValue('useconn',true); %consider connection validity?
pp.addParamValue('usecutoff',true); %cut the connection graph based on some threshold?
pp.parse(varargin{:});

adjmat = pp.Results.adjmat;
usecompscore = pp.Results.usecompscore;

if isempty(adjmat);
    if ~isempty(obj.m_adjmat_invalid_comp2comp)
        [~,adjmat] = obj.update_invalid_edges_comp2comp('useconn',pp.Results.useconn && pp.Results.usecutoff);
        adjmat = ~adjmat;
    else
        adjmat = obj.m_adjmat_comp2comp;
    end
end
ncompts = size(obj.m_compts,2);

overlapcost = obj.m_overlapcost_comp2comp;
if isempty(overlapcost)
    overlapcost = zeros(ncompts,ncompts);
end

structscore = obj.m_structscore_comp2comp_raw;
if isempty(structscore) || ~pp.Results.useconn
    structscore = ones(ncompts,ncompts);
end

conflictscore = obj.m_conflictscore_comp2comp;
if isempty(conflictscore)
    conflictscore = ones(ncompts,ncompts);
end

% scoremat_comp2comp = (1-overlapcost).*structscore.*conflictscore*1e3;
scoremat_comp2comp = (1-overlapcost).*structscore.*1e3;

if usecompscore
    compscores = obj.m_compscores;
    [xx,yy] = ndgrid(compscores,compscores);
    scoremat_comp2comp = scoremat_comp2comp.*xx.*yy*1e2;
end

scoremat_comp2comp(~adjmat) = 0;
adjmat = scoremat_comp2comp;
%%
if GLOBALCONST.DBG_CHECK('connect if cover','SAMPLEGRAPH: returning full graph')
    adjmat(:) = 1;
    adjmat(eye(size(adjmat))>0) = false;
end

end


