function obj = init_with_essential( obj )
sketchdata = obj.m_sketchdata;
database = obj.m_database;

assert(~isempty(sketchdata),'must have sketchdata to initialize full data');
assert(~isempty(database),'must have database to initialize full data');

samplegraph = obj.m_samplegraph;
if isempty(samplegraph)
    fprintf(1,'FULLDATA: creating sample graph\n');
    makesamplegraph;
    obj.m_samplegraph = objgraph;
    samplegraph = objgraph;
end

if ~isempty(obj.m_solist)
    fprintf(1,'FULLDATA: realizing solutions\n');
    for i=1:length(obj.m_solist)
        obj.m_solist{i} = obj.m_solist{i}.realize(samplegraph,database);
    end
end

if ~isempty(obj.m_solist_refined)
    fprintf(1,'FULLDATA: realizing refined solutions\n');
    for i=1:length(obj.m_solist_refined)
        obj.m_solist_refined{i} = obj.m_solist_refined{i}.realize(samplegraph,database);
    end
end

if ~isempty(obj.m_solist_mip)
    fprintf(1,'FULLDATA: realizing mip solutions\n');
    for i=1:length(obj.m_solist_mip)
        obj.m_solist_mip{i} = obj.m_solist_mip{i}.realize(samplegraph,database);
    end
end

if ~isempty(obj.m_solist_control)
    fprintf(1,'FULLDATA: realizing controlled solutions\n');
    for i=1:length(obj.m_solist_control)
        obj.m_solist_control{i} = obj.m_solist_control{i}.realize(samplegraph,database);
    end
end

if ~isempty(obj.m_sol_manual)
    obj.m_sol_manual = obj.m_sol_manual.realize(samplegraph,database);
end

if ~isempty(obj.m_subcovermat_subsk2sol)
    fprintf(1,'FULLDATA: initializing subcovers\n');
    obj.m_subcovermat_subsk2sol = ...
        cellfun(@(x)SBSRSUBSTRUCTCOVER.init_with_essential(x,samplegraph,database),obj.m_subcovermat_subsk2sol,'uniformoutput',false);
end

if ~isempty(obj.m_sublabelmat_subsk2sol)
    fprintf(1,'FULLDATA: initializing sublabels\n');
    obj.m_sublabelmat_subsk2sol = ...
        cellfun(@(x)SBSRSUBSTRUCTLABEL.init_with_essential(x,samplegraph,database),obj.m_sublabelmat_subsk2sol,'uniformoutput',false);
end

if ~isempty(obj.m_subobjmat_subsk2sol)
    fprintf(1,'FULLDATA: initializing 3d substructures\n');
    obj.m_subobjmat_subsk2sol = ...
        cellfun(@(x)COMPOUND.init_with_essential(x,samplegraph,database),obj.m_subobjmat_subsk2sol,'uniformoutput',false);
end

disp('FULLDATA: done');

end

