classdef SBSRFULLDATA
    % complete data for an experiment
    
    properties
        m_sketchdata
        m_samplegraph
        m_database
        
        % manually constructed reference solution
        m_sol_manual
        
        % solutions solved by mip
        m_solist_mip
        
        % iteratively refined solutions
        m_solist_refined
        
        % iterative refinement steps
        m_solist_per_step
        
        % per term evaluation
        m_solist_perterm;
        
        % for comparison experiments
        m_lbmap_sbsr_fixview %label map obtained from sbsr
        m_comp_sbsr_fixview %component obtained from sbsr
        
        m_idxsol_handpick %hand picked solution in mip
        m_lbmap_handpick
    end
    
    properties(Access=private) %useless properties
        % solutions obtained under manual control
        m_solist_control
        m_solist
        
        % 2d sketch substructure
        m_seglbs_per_subsketch
        
        % 3d substructure for each subsketch and each solution
        m_subobjmat_subsk2sol
        
        % evaluated cover information
        m_subcovermat_subsk2sol
        
        % evaluated sublabels
        m_sublabelmat_subsk2sol
        m_lbmap_direct_vote
        m_lbmap_direct_best
        m_lbmap_substruct_vote
        m_lbmap_substruct_best
    end
    
    methods
        obj = clear_non_essential(obj);
        obj = init_with_essential(obj);
        expand_to_base(obj);
    end
    
end

