//===========================================================================
// This code implements the superpixel method described in:
//
// Hao Du, Shengfeng He, Bin Sheng, Lizhuang Ma, Rynson Lau,
// " Saliency-Guided Color-to-Gray Conversion Using Region-Based Optimization ",
// Image Processing, IEEE Transactions on 24, no. 1 (2015): 434-443.
//
//////////////////////////////////////////////////////////////////////
#include <iostream>
#include "Color2Grey.h"

using namespace std;

#pragma comment(lib,"SGRPC2G.lib")
void main()
{
	C2G myc2g;
	clock_t t;
	for (int imgidx = 1; imgidx <= 22; imgidx++){
		stringstream imgnumstr;
		imgnumstr << imgidx;
		string imgname = "pics\\CSDD\\" + imgnumstr.str() + ".png";
		string savepath = string("pics\\CSDDRes\\") + imgnumstr.str() + ".png";

		//Set the input color image name
		myc2g.setFilePath(imgname);

		t = clock();

		//Initialize data
		myc2g.init();
		//Calculate the gray image
		myc2g.calGreyImage();
		//Set the path of gray image
		myc2g.saveGreyImage(savepath);

		t = clock() - t;
		cout << "done! " << (float)t / CLOCKS_PER_SEC << " seconds" << endl;

		myc2g.clean();
	}
	system("pause");
	return;
}