#include <iostream>
#include "cv.h"
#include "highgui.h"
#include <sstream>
#include "basic.h"
#include <cfloat>
#include <fstream>
#include <ctime>
using namespace cv;

class C2G{
private:
	string drive;
	string dir;
	string fname;
	string ext;
	string filepath;
	string savepath;

	IplImage *img;
	IplImage *lab;
	IplImage * greyImg;
	IplImage * VACImg;
	int w;
	int h;
	double **distanceWeight;
	double ** mapa;
	double ** mapb;
	double DELTA;
	int *superpixels;
	int superpixelsNum;
	static const int MAX_SEGMENT_NUM = 1500;
	static int MAX_IMG_LEN;
	vector<MyPoint> superpixelList[MAX_SEGMENT_NUM];
	segment segList[MAX_SEGMENT_NUM];

	int initDistWeight();
	int initSuperpixels();
	void calSalC();
	void initMapAB();
	void getGreyPara(IplImage * input, int k, int l, double avgg[]);
	void calSalGPara(double salg[], double avgg[]);
	void getBestKL(int &k,int &l);
	void getGrey(IplImage * out, IplImage * input, int k, int l);
	void mat2grey(IplImage *greyImg);
	void initSegList();
public:
	void setFilePath(string name){
		filepath = name;
		char cdrive[_MAX_DRIVE];
		char cdir[_MAX_DIR];
		char cfname[_MAX_FNAME];
		char cext[_MAX_EXT];
		_splitpath(filepath.c_str(), cdrive, cdir, cfname, cext);
		drive.append(cdrive);
		dir.append(cdir);
		fname.append(cfname);
		ext.append(cext);
		savepath = drive + dir + fname + "_result" + ext;
	}
	void calGreyImage();
	void init();
	IplImage * getGreyImage();
	void saveGreyImage(string savepath);
	void saveGreyImage();

	void clean(){
		drive.clear();
		dir.clear();
		fname.clear();
		ext.clear();
		filepath.clear();
		savepath.clear();
		cvReleaseImage(&img);
		cvReleaseImage(&lab);
		cvReleaseImage(&VACImg);
		cvReleaseImage(&greyImg);

		delete[] superpixels;
		for (int i = 0; i < h; i++){
			delete[] mapa[i];
			delete[] mapb[i];
		}
		delete[] mapa;
		delete[] mapb;
		for (int i = 0; i<MAX_IMG_LEN; i++){
			delete [] distanceWeight[i];
		}
		delete[] distanceWeight;
	}

	~C2G(){
	}
};